package com.xxfc.platform.vehicle.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.vehicle.constant.BranchCompanyStockApplyState;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompanyStockApplyInfo;
import com.xxfc.platform.vehicle.entity.BranchCompanyStockRight;
import com.xxfc.platform.vehicle.mapper.BranchCompanyStockApplyInfoMapper;
import com.xxfc.platform.vehicle.pojo.BranchCompanyStockApplyInfoVo;
import com.xxfc.platform.vehicle.pojo.BranchCompanyStockApplyVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


@Service
public class BranchCompanyStockApplyInfoBiz extends BaseBiz<BranchCompanyStockApplyInfoMapper, BranchCompanyStockApplyInfo> {

    @Autowired
    BranchCompanyStockRightBiz branchCompanyStockRightBiz;


    /**
     * 申请购买
     * @param applyVo
     */
    public void apply(BranchCompanyStockApplyVo applyVo) {
        BranchCompanyStockRight stockInfo = branchCompanyStockRightBiz.selectById(applyVo.getCompanyId());
        if (stockInfo == null) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_UNEXIST.getDesc(), ResCode.BRANCH_COMPANY_STOCK_UNEXIST.getCode());
        }
        if (stockInfo.getBalance() <= 0) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_NO_BALANCE.getDesc(), ResCode.BRANCH_COMPANY_STOCK_NO_BALANCE.getCode());
        }
        if (stockInfo.getBalance() < applyVo.getCount()) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getDesc(), ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getCode());
        }
        BranchCompanyStockApplyInfo applyInfo = new BranchCompanyStockApplyInfo();
        BeanUtils.copyProperties(applyVo, applyInfo);
        applyInfo.setState(BranchCompanyStockApplyState.Apply.getCode());
        applyInfo.setCreateTime(new Date());
        mapper.insertSelective(applyInfo);

    }

    public PageInfo<BranchCompanyStockApplyInfoVo> selectApplyAll(Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(mapper.selectVoAll());
    }

    /**
     * 取消申请,修改申请状态
     * @param applyId
     */
    public void cancelApply(Integer applyId) {
        BranchCompanyStockApplyInfo applyInfo = mapper.selectByPrimaryKey(applyId);
        if (applyInfo == null) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_UNEXIST.getDesc(),
                    ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_UNEXIST.getCode());
        }
        applyInfo.setState(BranchCompanyStockApplyState.Cancel.getCode());
        applyInfo.setUpdateTime(new Date());
        mapper.updateByPrimaryKeySelective(applyInfo);
    }

    /**
     * 确认申请购买股权，修改库存
     * @param applyId
     */
    @Transactional
    public void buy(Integer applyId) {
        BranchCompanyStockApplyInfo applyInfo = mapper.selectByPrimaryKey(applyId);
        if (applyInfo == null) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_UNEXIST.getDesc(),
                    ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_UNEXIST.getCode());
        }
        if (!applyInfo.getState().equals(BranchCompanyStockApplyState.Apply.getCode())) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_STATE_LOCKED.getDesc(),
                    ResCode.BRANCH_COMPANY_STOCK_APPLY_INFO_STATE_LOCKED.getCode());
        }

        BranchCompanyStockRight stockInfo = branchCompanyStockRightBiz.selectById(applyInfo.getCompanyId());
        if (stockInfo == null) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_UNEXIST.getDesc(), ResCode.BRANCH_COMPANY_STOCK_UNEXIST.getCode());
        }

        if (stockInfo.getBalance() < applyInfo.getCount()) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getDesc(), ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getCode());
        }

        int result = branchCompanyStockRightBiz.updateBalance(applyInfo.getCompanyId(), stockInfo.getBalance() - applyInfo.getCount(), stockInfo.getBalance());
        if (result == 0) {
            throw new BaseException(ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getDesc(), ResCode.BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH.getCode());
        }

        applyInfo.setState(BranchCompanyStockApplyState.Buy.getCode());
        applyInfo.setUpdateTime(new Date());
        mapper.updateByPrimaryKey(applyInfo);
    }

    public BranchCompanyStockApplyInfo getApplyById(Integer id) {
        return mapper.selectByPrimaryKey(id);
    }

    public void updateApply(BranchCompanyStockApplyInfo applyInfo) {
        mapper.updateByPrimaryKeySelective(applyInfo);
    }

    public void deleteApply(Integer id) {
        mapper.deleteByPrimaryKey(id);
    }


}
