package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

@Data
@Table(name = "company_base")
public class CompanyBase {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 分公司名称
     */
    @ApiModelProperty("分公司名称")
    private String name;

    /**
     * 公司封面
     */
    @ApiModelProperty("公司封面")
    private String cover;

    /**
     * 轮播图
     */
    @ApiModelProperty("轮播图")
    private String images;

    /**
     * 片区id
     */
    @Column(name = "zone_id")
    @ApiModelProperty("片区id")
    private Integer zoneId;


    /**
     * 公司简介
     */
    @ApiModelProperty("公司简介")
    private String describes;

    /**
     * 详情
     */
    @ApiModelProperty("详情")
    private String content;



    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "addr_province")
    @ApiModelProperty("地址-省/直辖市(编码)")
    private Integer addrProvince;

    /**
     * 地址-市(编码)
     */
    @Column(name = "addr_city")
    @ApiModelProperty("地址-市(编码)")
    private Integer addrCity;

    /**
     * 地址-镇/县（编码）
     */
    @Column(name = "addr_town")
    @ApiModelProperty("地址-镇/县（编码）")
    private Integer addrTown;


    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty("创建时间")
    private Long crtTime;


    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty("更新时间")
    private Long updTime;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty("更新时间")
    private Integer isDel;



}