package com.xxfc.platform.vehicle.entity;

import lombok.Data;
import javax.persistence.*;
import java.math.BigDecimal;

@Data
@Table(name = "branch_company_stock_info_right")
public class BranchCompanyStockRight{
    /**
     * 分公司ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    private Integer id;

    /**
     * 有限公司id
     */
    @Column(name = "company_base_id")
    private Integer companyBaseId;

    /**
     * 剩余股份
     */
    private Integer balance;

    /**
     * 股份总数
     */
    private Integer total;

    /**
     * 股份单价
     */
    private BigDecimal price;

    /**
     * 股价类型:1-万/股；2-港万/股
     */
    private Integer type;

    private Integer state;


    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 排序
     */
    private Integer rank;


    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    private Integer isDel;

}