package com.xxfc.platform.vehicle.pojo.vo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 分公司信息
 */
@Data
public class CompanyVo extends PageParam {

    /**
     * 公司基本信息表
     */
    @ApiModelProperty("公司基本信息id")
    Integer id;
    @ApiModelProperty("公司全名称")
    String  name;
    @ApiModelProperty("公司封面")
    String  cover;
    @ApiModelProperty("轮播图")
    String  images;
    @ApiModelProperty("片区id")
    Integer  zoneId;
    @ApiModelProperty("片区名称")
    String  zoneName;
    @ApiModelProperty("公司简介")
    String  describes;
    @ApiModelProperty("详情")
    String  content;
    @ApiModelProperty("地址-省/直辖市(编码)")
    Integer addrProvince;
    @ApiModelProperty("地址-省/直辖市(编码)名称")
    String provinceName;
    @ApiModelProperty("地址-市(编码)")
    Integer addrCity;
    @ApiModelProperty("地址-市(编码)名称")
    String cityName;
    @ApiModelProperty("地址-镇/县（编码)")
    Integer addrTown;
    @ApiModelProperty("地址-镇/县（编码)名称")
    String townName;

    /**
     * 分支机构
     */
    @ApiModelProperty("分支机构id")
    Integer companyId;
    @ApiModelProperty("分支机构名称")
    String companyName;
    @ApiModelProperty("详细地址")
    String addrDetail;
    @ApiModelProperty("上下架:1-上架；2-下架")
    Integer state;
    @ApiModelProperty("负责人")
    private String leader;
    @ApiModelProperty("负责人联系方式")
    private String leaderContactInfo;
    @ApiModelProperty("公司状态")
    private Integer status;
    @ApiModelProperty("公司地址-纬度")
    private BigDecimal latitude;
    @ApiModelProperty("公司地址-经度")
    private BigDecimal longitude;
    @ApiModelProperty("租车客服电话")
    private String vehiceServicePhone;
    @ApiModelProperty("旅游客服电话")
    private String tourServicePhone;
    /**
     * 股权信息
     */
    @ApiModelProperty("股份id")
    Integer stockId;
    @ApiModelProperty("剩余股份")
    Integer balance;
    @ApiModelProperty("股份总数")
    Integer total;
    @ApiModelProperty("股份单价")
    BigDecimal price;
    @ApiModelProperty("排序")
    Integer rank;
    @ApiModelProperty("(-1:下架，0:筹备中，1:筹备完成，2:上架)")
    Integer stockState;
    @ApiModelProperty("股价类型:1-万/股；2-港万/股")
    Integer type;
}
