package com.xxfc.platform.order.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.order.biz.OrderActivityDetailBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderActiveDetail;
import com.xxfc.platform.order.pojo.dto.OrderActivityDto;
import com.xxfc.platform.order.pojo.order.ActivityOrderBO;
import com.xxfc.platform.order.service.OrderActivityService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping(value = "/order/activity")
public class OrderActivityController extends BaseController<OrderActivityDetailBiz, OrderActiveDetail> {

	@Autowired
	UserFeign userFeign;

	@Autowired
	OrderActivityService orderActivityService;

	@RequestMapping(value = "add", method = RequestMethod.POST)
	@ResponseBody
	@ApiOperation(value = "确认活动订单")
	public ObjectRestResponse<BaseOrder> add(@RequestBody OrderActivityDto dto, HttpServletRequest request) {
		ActivityOrderBO bo = BeanUtil.toBean(dto, ActivityOrderBO.class);
		bo.setAppUserDTO(userFeign.userDetailByToken(request.getHeader("Authorization")).getData());
		//查询优惠券
		orderActivityService.createOrder(bo);
		return ObjectRestResponse.succ(bo.getOrder());
	}



	@GetMapping(value = "/getAll")
	public ObjectRestResponse getAll(BaseOrderController.QueryOrderList dto) {
		return baseBiz.getAll(dto);
	}




	@GetMapping(value = "/detail")
	public ObjectRestResponse orderDetail(String no) {
		return baseBiz.orderDetail(no, userFeign.userDetailByToken(request.getHeader("Authorization")).getData());
	}

}
