package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.xxfc.platform.vehicle.biz.ConstantBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ConstantType;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.Constant;
import com.xxfc.platform.vehicle.pojo.ConstantVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/constant")
@Slf4j
@IgnoreClientToken
public class ConstantController extends BaseController<ConstantBiz> {


    @RequestMapping(value ="/type/{type}",method = RequestMethod.GET)
    public RestResponse<List<ConstantVo>> getAllConstantByType(@PathVariable Integer type){
        if(!checkIfTypeValid(type)){
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.data(baseBiz.getAllConstantByType(type));
    }

    /**
     * 检查类型是否合法
     * @param type
     * @return
     */
    private Boolean checkIfTypeValid(Integer type){
        Boolean exists = Boolean.FALSE;
        for(ConstantType constantType: ConstantType.values()){
            if(constantType.getCode().equals(type)){
                exists = Boolean.TRUE;
            }
        }
        return exists;
    }

    @RequestMapping(value ="/type/{type}",method = RequestMethod.POST)
    public RestResponse<Integer> add(@PathVariable Integer type,@RequestBody List<Constant> constants){
        if(!checkIfTypeValid(type)){
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if(CollectionUtils.isEmpty(constants)){
            return RestResponse.sucResponse();
        }
        for(Constant constant:constants){
            //编码和值不能为空
            if(constant.getCode()==null|| StringUtils.isBlank(constant.getVal())) {
                return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                        ResCode.INVALID_REST_REQ_PARAM.getDesc());
            }
        }
        return RestResponse.data(baseBiz.addConstants(type,constants));
    }

    @RequestMapping(value ="/type/{type}",method = RequestMethod.PUT)
    public RestResponse<Integer> update(@PathVariable Integer type,@RequestBody List<Constant> constants){
        if(!checkIfTypeValid(type)){
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if(CollectionUtils.isEmpty(constants)){
            return RestResponse.sucResponse();
        }
        for(Constant constant:constants){
            //编码和值不能为空
            if(constant.getCode()==null|| StringUtils.isBlank(constant.getVal())) {
                return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                        ResCode.INVALID_REST_REQ_PARAM.getDesc());
            }
        }
        return RestResponse.data(baseBiz.updateConstants(type,constants));
    }

    @RequestMapping(value ="/type/{type}",method = RequestMethod.DELETE)
    public RestResponse<Integer> del(@PathVariable Integer type,@RequestBody List<Integer> codes){
        if(!checkIfTypeValid(type)){
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if(CollectionUtils.isEmpty(codes)){
            return RestResponse.sucResponse();
        }
        for(Integer code:codes){
            //编码和值不能为空
            if(code==null) {
                return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                        ResCode.INVALID_REST_REQ_PARAM.getDesc());
            }
        }
        return RestResponse.data(baseBiz.delConstant(type,codes));
    }


}
