package com.xxfc.platform.campsite.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.campsite.biz.CampsiteTagBiz;
import com.xxfc.platform.campsite.entity.CampsiteTag;
import com.xxfc.platform.campsite.vo.CampsiteTagListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 营地类型
 * @data 2019/6/17 13:36
 */
@RestController
@RequestMapping("campsiteTag")
@Api(tags = "App营地类型")
public class CampsiteTagController extends BaseController<CampsiteTagBiz,CampsiteTag> {


     @GetMapping("/app/unauth/tags")
     @IgnoreClientToken
     @ApiOperation(value = "营地类型列表")
    public ObjectRestResponse<CampsiteTagListVo> findCampstieTags(){
         List<CampsiteTagListVo> campsiteTagListVolist = getBaseBiz().findCampsiteTags();
         return ObjectRestResponse.succ(campsiteTagListVolist);
     }
}