package com.github.wxiaoqi.security.common.msg;

import com.github.wxiaoqi.security.common.constant.RestCode;

/**
 * Created by ace on 2017/8/23.
 */
public class BaseResponse {
    private int status = 200;
    private String message = "SUCCESS";

    public BaseResponse(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public BaseResponse() {
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public BaseResponse status(int status) {
        this.status = status;
        return this;
    }

    public BaseResponse msg(String msg) {
        this.message = msg;
        return this;
    }

    public BaseResponse(RestCode restCode) {
        this.status = restCode.getStatus();
        this.message = restCode.getMsg();
    }

    public static BaseResponse success() {
        return new BaseResponse(RestCode.SUCCESS);
    }

}
