package com.xxfc.platform.universal.controller;




import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.xxfc.platform.universal.biz.WeixinService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

/**
 * 用户
 */
@RestController
@RequestMapping("info")
@IgnoreUserToken
public class UserInfoController {


    @Autowired
    WeixinService weixinService;

    @Value("${wx.sendUrl}")
    private String  sendUrl;


    @RequestMapping(value = "getOpenId", method = RequestMethod.GET) //匹配的是href中的download请求
    public ObjectRestResponse sendSms(HttpServletRequest request) throws Exception {
        boolean isWx = UserAgentUtil.isWexinBrowser(request);
        if (isWx) {
            //session里面获取用户信息
            String openId=weixinService.getSession(request);
            if (StringUtils.isBlank(openId)){
                JSONObject json = new JSONObject();
                json.put("sendUrl",sendUrl);

                return  ObjectRestResponse.createFailedResultWithObj(1001,"",json);
            }

            return ObjectRestResponse.succ(openId);
        }
        return ObjectRestResponse.succ();
    }

}

