package com.xxfc.platform.universal.biz;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.utils.HttpRequestUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


@Service
@Slf4j
public class WeixinService {

    /**
     * 网页
     */
    @Value("${wx.appid}")
    private String wy_appid;
    @Value("${wx.appSercet}")
    private String  wy_secret;
    public static final String frontSessionKey = "frontWeixKey";



    public  JSONObject getAccessToken(String code){
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?";
        String params = "appid="+wy_appid+"&secret="+wy_secret+"&code="+code+"&grant_type=authorization_code";
        String result = HttpRequestUtil.httpGet(url + params);
        JSONObject data = JSON.parseObject(result);
        return data;
    }

    public  JSONObject getValidateData(String access_token,String openid){
        String url = "https://api.weixin.qq.com/sns/auth?access_token=" + access_token + "&openid=" + openid;
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  JSONObject getRefreshToken(String refresh_token){
        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + wy_appid + "&grant_type=refresh_token&refresh_token=" + refresh_token;
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  JSONObject getUserInfo(String access_token,String openid){
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN";
        String result = HttpRequestUtil.httpGet(url);
        JSONObject data = JSON.parseObject(result);

        return data;
    }

    public  String getAuthorize(String redirec_url){
        String oauth_api = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={APPID}&redirect_uri={REDIRECT_URI}&response_type=code&scope={SCOPE}&state={STATE}#wechat_redirect";
        oauth_api = oauth_api.replace("{APPID}", wy_appid)
                .replace("{REDIRECT_URI}", redirec_url)
                .replace("{SCOPE}", "snsapi_base").replace("{STATE}", "state");
     log.info("---oauth_api===="+oauth_api);
     return oauth_api;
    }


    //获取缓存
    public  String getSession(HttpServletRequest request){
        try {
            HttpSession session = request.getSession();
            String frontSessionValue1 = (String) session.getAttribute(frontSessionKey);
            if (StringUtils.isBlank(frontSessionValue1)) {
                return  null;
            }
            String openId = Base64.decodeStr(frontSessionValue1);
            return openId;
        }catch (Exception e){
            e.printStackTrace();
            return  null;
        }

    }





}
