package com.xxfc.platform.tour.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 旅游商品
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class TourVerificationInfoVo implements Serializable {
	private static final long serialVersionUID = 1L;
	

	@ApiModelProperty("旅游线路核销id")
    private Integer verificationId;
	

	@ApiModelProperty(value = "旅游商品规格id")
    private Integer speId;

	@ApiModelProperty(value = "开始时间")
	private Date startTime;

	//结束时间
	@ApiModelProperty(value = "结束时间")
	private Date endTime;


	@ApiModelProperty(value = "时间区间")
	private String time;


	@ApiModelProperty(value = "出发路线id")
    private Integer siteId;

	@ApiModelProperty(value = "出发路线名称")
	private String siteName;

	@ApiModelProperty(value = "出发路线分公司id")
	private Integer companyId;
	

	@ApiModelProperty(value = "旅游路线id")
    private Integer goodId;

	@ApiModelProperty(value = "旅游路线名称")
	private String goodName;

	@ApiModelProperty(value = "出发路线分公司ids")
	private List<Integer> companyList;

	

}
