package com.xxfc.platform.tour.dto;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 商品规格
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class GoodSpePriceDTO {


	private Integer id;

	//出行时间
	@ApiModelProperty(value = "出行时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd",locale="zh", timezone = "GMT+8")
	private Date startTime;

	//结束时间
	@ApiModelProperty(value = "结束时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd",locale="zh", timezone = "GMT+8")
	private Date endTime;

	@ApiModelProperty("商品id")
	private Integer goodId;

	//规格id
	@ApiModelProperty(value = "规格id")
	private String speId;

	//价格
	@ApiModelProperty(value = "价格")
	private BigDecimal price;

	//儿童价格
	@ApiModelProperty(value = "儿童价格")
	private BigDecimal childPrice;

	//会员价格
	@ApiModelProperty(value = "会员价格")
	private String memberPrice;

	//库存
	@ApiModelProperty(value = "库存")
	private Integer stock;


}
