package com.xxfc.platform.summit.controller;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.biz.UserBiz;
import com.xxfc.platform.summit.entity.ActivityBm;
import com.xxfc.platform.summit.entity.User;
import com.xxfc.platform.summit.service.WeixinService;
import com.xxfc.platform.summit.vo.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @author Administrator
 */
@Controller
@RequestMapping("/auth")
@Slf4j
public class WeixinController {

    public static final String WECHAT_AUTOLOGIN_CALLBACKURL_KEY = "callback";
    public static final String WECHAT_REDIS_KEY = "key";

    @Autowired
    WeixinService weixinService;

    @Autowired
    UserBiz userBiz;

    @Autowired
    ActivityBmBiz activityBmBiz;

    public static final String frontSessionKey = "frontWeixKey";

    @Value("${wx.url}")
    private String  url;



    @RequestMapping(value ="/app/unauth/wxLogin",method = RequestMethod.GET)
    @IgnoreUserToken
    public String index(@RequestParam(value = "redirec_url")String redirec_url,
                        @RequestParam(value = "key")String key){
        log.info("-----微信wxLogin---redirec_url=="+redirec_url);
        if (StringUtils.isBlank(redirec_url)){
            redirec_url="";
        }
        try {
        String encrypt_curr_url = Base64.encode(redirec_url.getBytes("utf-8"));
        redirec_url=url+"?" + WECHAT_AUTOLOGIN_CALLBACKURL_KEY+ "=" + encrypt_curr_url+"&"+WECHAT_REDIS_KEY+"="+key;
        String  oauth_api=weixinService.getAuthorize(redirec_url);
        return  String.format("redirect:"+oauth_api);
        }catch (Exception e){
            e.printStackTrace();
            log.info("网络异常===" + e.getMessage());
            return  String.format("网络异常");
        }
    }

    /**
     * 微信浏览器获取用户信息
     * @param code
     * @param callback
     * @return
     */
    @GetMapping(value = "/app/unauth/userInfo")
    public String getUserInformation(String code, String callback,String key, HttpServletRequest request) {
        log.info("-----微信回调userInfo---code=="+code+"----redirec_url==="+callback+"---key==="+key);
        try {
            userBiz.authUser(code,key,request);
            callback =new String(Base64.decode(callback), "utf-8");
            log.info("callback===" + callback);
        }catch (Exception e){
            e.printStackTrace();
            log.info("网络异常===" + e.getMessage());
        }
        return  String.format("redirect:"+callback);
    }




}
