package com.xxfc.platform.summit.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activity")
public class ActivityController extends BaseController<ActivityBiz, Activity> {


    @PostMapping("/app/unauth/list")
    public ObjectRestResponse getList(@RequestBody ActivityQuery query ){
        return ObjectRestResponse.succ(baseBiz.getList(query));
    }

    @Override
    @PutMapping ("/update")
    public ObjectRestResponse update(@RequestBody Activity activity ){
        if (baseBiz.update(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @Override
    @PostMapping("/add")
    public ObjectRestResponse add(@RequestBody Activity activity ){
        if (baseBiz.add(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

}
