package com.xxfc.platform.summit.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.summit.entity.MeepoUserQd;
import com.xxfc.platform.summit.entity.User;
import com.xxfc.platform.summit.mapper.MeepoUserQdMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class MeepoUserQdBiz extends BaseBiz<MeepoUserQdMapper, MeepoUserQd> {

    @Autowired
    UserBiz userBiz;

    //添加签到信息
    public  void  addUserQd(Integer meepoUserId){
        if (meepoUserId==null||meepoUserId==0){
            log.info("----签到信息为空meepoUserId==="+meepoUserId);
            return;
        }
        User  user= userBiz.selectById(meepoUserId);
        Integer weId=user.getWeId();
        Integer rid=user.getRId();
        String openId=user.getOpenId();
        String avatar=user.getAvatar();
        String nikeName=user.getNickName();
        log.info("---addUserQd----meepoUserId==="+meepoUserId+"----openId==="+openId+"--weId=="+weId+"---rid==="+rid+"---avatar==="+avatar);
        Example example=new Example(MeepoUserQd.class);
        example.createCriteria().andEqualTo("weId",weId).andEqualTo("rId",rid).andEqualTo("openId",openId);
        List<MeepoUserQd> list=selectByExample(example);
        if (list.size()>0){
            log.info("----已签到---meepoUserId==="+meepoUserId+"----openId==="+openId);
            return;
        }
        MeepoUserQd meepoUserQd=new MeepoUserQd();
        meepoUserQd.setAvatar(avatar);
        meepoUserQd.setLevel(1);
        meepoUserQd.setNickName(nikeName);
        meepoUserQd.setOpenId(openId);
        meepoUserQd.setRId(rid);
        meepoUserQd.setWeId(weId);
        meepoUserQd.setCreateTime(System.currentTimeMillis()/1000L);
        insertSelective(meepoUserQd);

    }







}
