package com.xxfc.platform.order.pojo.price;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class RentVehiclePriceVO extends OrderPriceVO{
    @ApiModelProperty(value = "车辆价格")
    BigDecimal vehicleAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "司机价格")
    BigDecimal driverAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "免赔付价格")
    BigDecimal damageSafeAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "押金价格")
    BigDecimal deposit = BigDecimal.ZERO;
    @ApiModelProperty(value = "天数")
    Integer dayNum = 0;
    @ApiModelProperty(value = "车辆天数")
    Integer vehicleDayNum = 0;
    @ApiModelProperty(value = "车辆个数")
    Integer vehicleNum = 0;
    @ApiModelProperty(value = "司机个数")
    Integer driverNum = 0;
    @ApiModelProperty(value = "车型名称")
    String modelName = "";
    @ApiModelProperty(value = "车型价格")
    BigDecimal modelAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "司机单价")
    BigDecimal driverPrice = BigDecimal.ZERO;
    @ApiModelProperty(value = "免赔付单价")
    BigDecimal damageSafePrice = BigDecimal.ZERO;
    @ApiModelProperty(value = "费用详情")
    private String costDetail = "";

//    /**
//     * 原租车天数
//     */
//    private Integer originDayNum;

    /**
     * 免费天数
     */
    private Integer freeDayNum = 0;

    /**
     * 免费价格
     */
    private BigDecimal freeAmount = BigDecimal.ZERO;

    /**
     * 购买的租车金额
     */
    private BigDecimal buyVehicleAmount = BigDecimal.ZERO;

    /**
     * 最后的租车金额
     */
    private BigDecimal realVehicleAmount = BigDecimal.ZERO;

    /**
     * 优惠描述
     */
    private String couponDesc = "";

}
