package com.xxfc.platform.order.contant.enumerate;


import java.util.HashMap;
import java.util.Map;

public enum OrderViolateEnum {
    BEFORE(1, "提前"),
    AFTER(2, "延期"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, OrderTypeEnum> codeAndDesc = new HashMap<Integer, OrderTypeEnum>();
    //Maps.newHashMap();

    static{
        for(OrderTypeEnum enumE : OrderTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    OrderViolateEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static OrderTypeEnum get(Integer code) {
        for(OrderTypeEnum enumE : OrderTypeEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}
