package com.xxfc.platform.app.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.biz.BuyVehicleFormBiz;
import com.xxfc.platform.app.entity.dto.BuyVehicleFormFindDTO;
import com.xxfc.platform.app.entity.vo.BuyVehicleFormPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/9 13:55
 */
@RestController
@RequestMapping("admin/buy_vehicle")
public class BuyVehicleFormAdminController {

     @Autowired
     private BuyVehicleFormBiz vehicleFormBiz;

     @PostMapping("/page")
     public ObjectRestResponse<BuyVehicleFormPageVo> findBuyVehicleFormWithPage(@RequestBody  BuyVehicleFormFindDTO buyVehicleFormFindDTO){
          PageDataVO<BuyVehicleFormPageVo> pageDataVO = vehicleFormBiz.findBuyVehicleFormWithPage(buyVehicleFormFindDTO);
          return ObjectRestResponse.succ(pageDataVO);
     }

     @PostMapping("/status/{id}")
     public ObjectRestResponse<Void> processApplyById(@PathVariable(value = "id") Integer id){
          vehicleFormBiz.processApplyStatusById(id);
          return  ObjectRestResponse.succ();
     }
}
