package com.xxfc.platform.activity.handler;


import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.admin.dto.RegisterQueueDTO;
import com.rabbitmq.client.Channel;
import com.xxfc.platform.activity.biz.ActivityPopularizeBiz;
import com.xxfc.platform.activity.biz.ActivityUserJoinBiz;
import com.xxfc.platform.activity.biz.UserCouponBiz;
import com.xxfc.platform.activity.config.RabbitActivityConfig;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Component
@Slf4j
public class CouponMQHandler {

    @Autowired
    ActivityPopularizeBiz activityPopularizeBiz;

    @Autowired
    ActivityUserJoinBiz activityUserJoinBiz;

    @Autowired
    UserCouponBiz userCouponBiz;

    @RabbitListener(queues = {RabbitActivityConfig.COUPON_CANCEL_QUEUE})
    public void popularizeHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    log.info("接收到的消息：msg = {}, 消息ID是：messageId = {} ", msg, messageId);

                    if (StringUtils.isNotBlank(msg)) {
                        OrderMQDTO orderMQDTO = JSONUtil.toBean(msg, OrderMQDTO.class);
                        if(StrUtil.isNotBlank(orderMQDTO.getCouponTickerNos())) {
                            for(String tickerNo : orderMQDTO.getCouponTickerNos().split(",")) {
                                // 返还优惠券
                                userCouponBiz.cancelTickerNo(tickerNo);
                            }
                        }
                    }

                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        i.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
    }

}
