package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppUserPositionBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserPositionTempBiz;
import com.github.wxiaoqi.security.admin.dto.AppUserPositionTempDTO;
import com.github.wxiaoqi.security.admin.dto.AppUserPositionTempFindDTO;
import com.github.wxiaoqi.security.admin.dto.UserPostionDTO;
import com.github.wxiaoqi.security.admin.vo.AppUserPositionTempVo;
import com.github.wxiaoqi.security.admin.vo.WalletPostionVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.excel.ExcelImport;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/17 16:13
 */
@RestController
@RequestMapping("/postion/admin")
public class AppUserPositionController {

    @Autowired
    private AppUserPositionBiz appUserPositionBiz;

    @Autowired
    private AppUserPositionTempBiz appUserPositionTempBiz;

    @GetMapping("/postions")
    public ObjectRestResponse<List<WalletPostionVo>> findAllPostions() {
        List<WalletPostionVo> walletPostionVos = appUserPositionBiz.findAllPostions();
        return ObjectRestResponse.succ(walletPostionVos);
    }

    @PutMapping
    public ObjectRestResponse updateUserPostionPercentage(@RequestBody List<UserPostionDTO> userPostionDTOS) {
        appUserPositionBiz.updateUserPostionPercentage(userPostionDTOS);
        return ObjectRestResponse.succ();
    }


    /**
     * 新增或编辑身份信息
     * @return
     */
    @PostMapping("/add")
    public ObjectRestResponse<Void> addUserPostion(@RequestBody AppUserPositionTempDTO appUserPositionTempDTO){
         appUserPositionTempBiz.add(appUserPositionTempDTO);
        return ObjectRestResponse.succ();
    }

    /**
     * 批量导入
     * @param userPostionExcel
     * @return
     */
    @PostMapping("/excel/import")
    public ObjectRestResponse<Map<String,Object>> importUserPostion(@RequestPart("file") MultipartFile userPostionExcel) {
        List<String[]> userPostionData = ExcelImport.getExcelData(userPostionExcel);
        if (userPostionData.size() < 2) {
            return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
        }
        userPostionData.remove(0);
        Map<String,Object> result = appUserPositionTempBiz.importUserPostion(userPostionData);
        return ObjectRestResponse.succ(result);
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ObjectRestResponse<Void> deleteUserPostion(@PathVariable(value = "id") Integer id){
        appUserPositionTempBiz.updateAppuserPostionStatusById(id,1);
        return ObjectRestResponse.succ();
    }

    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<AppUserPositionTempVo>> findWithPage(@RequestBody AppUserPositionTempFindDTO appUserPositionTempFindDTO){
       PageDataVO<AppUserPositionTempVo>  dataVO =  appUserPositionTempBiz.findWithPage(appUserPositionTempFindDTO);
       return ObjectRestResponse.succ(dataVO);
    }

}
