package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.admin.vo.SellingWalletPagVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 11:35
 */
@RestController
@RequestMapping("/sellingwater")
public class UserSellingWaterController {

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @GetMapping("/page")
    public ObjectRestResponse<SellingWalletPagVo> findSellingWaterPage(@RequestParam(required = false,value = "type") Integer wating,
                                                                       @RequestParam("pageNo") Integer pageNo,
                                                                       @RequestParam("pageSize") Integer pageSize,
                                                                       HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            SellingWalletPagVo sellingWalletPagVo = appUserSellingWaterBiz.findSellingWaterPageByWaiting(wating, Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
            return ObjectRestResponse.succ(sellingWalletPagVo);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @GetMapping("/pagea")
    public ObjectRestResponse<SellingWalletPagVo> findSellingWaterPagea(@RequestParam(required = false,value = "type") Integer wating,
                                                                       @RequestParam("pageNo") Integer pageNo,
                                                                       @RequestParam("pageSize") Integer pageSize,
                                                                       HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            SellingWalletPagVo sellingWalletPagVo = appUserSellingWaterBiz.findSellingWaterPageForAppByWaiting(wating, Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
            return ObjectRestResponse.succ(sellingWalletPagVo);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }
}
