package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.UserPostionDTO;
import com.github.wxiaoqi.security.admin.vo.WalletPostionVo;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.select.Collector;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.admin.entity.AppUserPosition;
import com.github.wxiaoqi.security.admin.mapper.AppUserPositionMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 用户身份职位表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Transactional
@Service("appUserPositionBiz")
public class AppUserPositionBiz extends BaseBiz<AppUserPositionMapper,AppUserPosition> {


    //获取用户职位的折扣
    public  AppUserPosition getExtract(Integer userId){
         return  mapper.getExtractByUserId(userId);
    }

    public List<WalletPostionVo> findAllPostions() {
         List<WalletPostionVo> walletPostionVos = new ArrayList<>();
        List<AppUserPosition> appUserPositions = mapper.selectAll();
        if (CollectionUtils.isEmpty(appUserPositions)){
            return walletPostionVos;
        }
          WalletPostionVo walletPostionVo;
        for (AppUserPosition appUserPosition : appUserPositions) {
            walletPostionVo  = new WalletPostionVo();
            BeanUtils.copyProperties(appUserPosition,walletPostionVo);
            walletPostionVos.add(walletPostionVo);
        }
        return walletPostionVos;
    }

    public int updateUserPostionPercentage(List<UserPostionDTO> userPostionDTOS) {
        AtomicInteger  counter  = new AtomicInteger(0);
        for (UserPostionDTO userPostionDTO : userPostionDTOS) {
            AppUserPosition appUserPosition = new AppUserPosition();
            appUserPosition.setId(userPostionDTO.getId());
            appUserPosition.setExtract(userPostionDTO.getExtract());
            mapper.updateByPrimaryKeySelective(appUserPosition);
            counter.incrementAndGet();
        }
        return counter.get();
    }

    public Map<Integer, AppUserPosition> findPostionIdAndPostionMapByIds(List<Integer> postionIds) {
        Map<Integer,AppUserPosition> postionMap = new HashMap<>();
        List<AppUserPosition> data= mapper.selectByIdList(postionIds);
        if(CollectionUtils.isEmpty(data)){
            return postionMap;
        }
        postionMap = data.stream().collect(Collectors.toMap(AppUserPosition::getId, Function.identity()));
        return postionMap;
    }

    public Map<Integer, String> findPostionIdAndNameMap() {
        List<AppUserPosition> postions = selectListAll();
        return postions.stream().collect(Collectors.toMap(AppUserPosition::getId,AppUserPosition::getName));
    }
}