package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品拥金表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 18:34:39
 */
@Data
@Table(name = "base_good_commission")
public class BaseGoodCommission implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  商品id
     */
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;
	
	    /**
     *  1-租车；2-旅游；3-会员订单;4-营地
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1-租车；2-旅游；3-会员订单;4-营地")
    private Integer type;
	
	    /**
     *  是否计算；0-不计算；1计算
     */
    @Column(name = "is_reckon")
	@ApiModelProperty(value = "是否计算；0-不计算；1计算")
    private Integer isReckon;
	
	    /**
     *  拥金比例
     */
    @Column(name = "extract")
	@ApiModelProperty(value = "拥金比例")
    private Integer extract;
	

}
