package com.xxfc.platform.universal.service.authenticationInterface.impl;


import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.universal.biz.UserMessage;
import com.xxfc.platform.universal.service.authenticationInterface.UserAuthentication;
import com.xxfc.platform.universal.utils.CertifHttpUtils;
import com.xxfc.platform.universal.utils.HttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 调用四川涪擎认证接口
 *
 * @author Administrator
 */
@Service
@Slf4j
@Primary
public class XCFQAuthentication implements UserAuthentication {

    //    private String appcode="acea1c8811f748b3a65815f11db357c4";
    private String appcode2 = "ee7710ce92054cae9f6c040f6864e6a7";

    /**
     * 认证相关的数据
     */
    private String hsot = "https://idcert.market.alicloudapi.com";

    private String path = "/idcard";

    private String method = "GET";

    //响应:认证错误码字段名
    private String certifRet = "status";

    //响应:认证通过码
    private String certifResultCode = "01";

    //请求:身份证号字段名
    private String idCardName = "idCard";

    //请求:用户姓名字段名
    private String cName = "name";

    @Override
    public boolean certificate(UserMessage message) {

        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode2);
        try {
           return callExternalRequest(message, headers, 1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    private boolean callExternalRequest(UserMessage message, Map<String, String> headers, int type) throws Exception {
        //map携带身份证和姓名进行认证
        Map<String, String> querys = new HashMap<>();
        querys.put(idCardName, message.getIdNumber());
        querys.put(cName, message.getName());
        log.info("----querys=========" + querys);
        HttpResponse response = HttpUtils.doGet(hsot, path, method, headers, querys);
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        /**
         * 状态码: 200 正常；400 URL无效；401 appCode错误； 403 次数用完； 500 API网管错误
         */
        log.info("外部接口响应状态码:" + statusCode);
        //获取response的body

        if (statusCode == 200) {
            String result = EntityUtils.toString(response.getEntity());
            log.info("----认证结果result=========" + result);
            //认证返回的参数是否为空
            if (!StringUtils.isBlank(result)) {
                Map<String,String> map = (Map<String, String>) JSONObject.parse(result);
                log.info("----响应数据=========" + map);
                if (MapUtil.isNotEmpty(map) && certifResultCode.equals(map.get("status"))) {
                    log.info("认证成功");
                    return true;
                }
            }
        }

        if (403 == statusCode) {
            log.error("验证次数已用完");
        }

        return false;
    }
}
