package com.xxfc.platform.vehicle.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.universal.inter.CalculateInterface;
import com.xxfc.platform.vehicle.biz.*;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.BookType;
import com.xxfc.platform.vehicle.constant.VehicleBookRecordStatus;
import com.xxfc.platform.vehicle.constant.VehicleMemberType;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.pojo.*;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.vo.UsableVeicleVO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

import static cn.hutool.core.date.DateField.HOUR_OF_DAY;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.*;
import static com.xxfc.platform.vehicle.constant.VehicleConstant.USER_APP;
import static com.xxfc.platform.vehicle.constant.VehicleConstant.USER_APP_NAME;

@RestController
@RequestMapping("/vehicleInfo")
@Slf4j
@IgnoreClientToken
@Api(value="租车相关车辆管理controller",tags={"租车相关车辆管理接口"})
public class RentVehicleController extends BaseController<VehicleBiz> implements UserRestInterface, CalculateInterface {
    private static final Integer DEFAULT_DISCOUNT = 100;
    private static final Integer DEFAULT_MEMBER_LEVEL = 0;
    private static final Integer DEFAULT_MEMBER_TYPE = 0;

    private static final Integer MEMBER_TYPE_ALL = 1;
    private static final Integer MEMBER_TYPE_FORBID = 4;

    @Autowired
    private VehiclePlatCataBiz vehiclePlatCataBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    VehicleBookRecordBiz vehicleBookRecordBiz;

    @Autowired
    VehicleBookInfoBiz vehicleBookInfoBiz;

    @Autowired
    VehicleHolidayPriceInfoBiz vehicleHolidayPriceInfoBiz;


    @Override
    public ThirdFeign getThirdFeign() {
        return thirdFeign;
    }

    public UserFeign getUserFeign() {
        return userFeign;
    }

    /**
     * 租车拒绝预定车辆申请
     *
     * @param bookRecordId
     * @return
     */
    @RequestMapping(value = "/rent/book/reject/{bookRecordId}", method = RequestMethod.PUT)
    @ApiOperation(value = "租车拒绝预定车辆")
    @IgnoreUserToken
    public RestResponse<Integer> rentRejectVehicleBooking(@PathVariable Long bookRecordId) throws Exception {
        //默认USER_APP 预约
        Integer operatorId = USER_APP;
        String userName = USER_APP_NAME;
        return baseBiz.reviewVehicleBooking(operatorId, bookRecordId, VehicleBookRecordStatus.REJECTED.getCode(), userName, "租车订单取消", Boolean.TRUE);
    }

    /**
     * 取消车辆预订
     *
     * @param bookRecordId
     * @return
     */
    @RequestMapping(value = "/rent/unbook/{bookRecordId}", method = RequestMethod.DELETE)
    @ApiOperation(value = "取消预定车辆")
    @IgnoreUserToken
    public RestResponse<Integer> rentUnbookVehicle(@PathVariable Long bookRecordId) throws Exception {
        //默认USER_APP 预约
        Integer operatorId = USER_APP;
        String userName = USER_APP_NAME;
        return baseBiz.unbookVehicle4Employee(operatorId, bookRecordId, userName,null, Boolean.TRUE);
    }

    /**
     * 批准预定车辆预定
     *
     * @param bookRecordId
     * @return
     */
    @RequestMapping(value = "/rent/book/prove/{bookRecordId}", method = RequestMethod.PUT)
    @ApiOperation(value = "预定车辆审核通过")
    @IgnoreUserToken
    public RestResponse<Integer> rentProveVehicleBooking(@PathVariable Long bookRecordId) throws Exception {
        //默认USER_APP 预约
        Integer operatorId = USER_APP;
        String userName = USER_APP_NAME;
        return baseBiz.reviewVehicleBooking(operatorId, bookRecordId, VehicleBookRecordStatus.APPROVE.getCode(), userName, "", Boolean.TRUE);
    }

    /**
     * 可用车辆查询
     *
     * @param dto
     * @return
     */
    @ApiOperation("可用车辆查询")
    @RequestMapping(value = "/rent/usable-vehicle", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<UsableVehicleModelVO>> rentUsableVehicle(UsableVeicleDTO dto) throws Exception {
        //根据时间 获得 可用车辆
        //结合车型
        if (StringUtils.isNotBlank(dto.getCatasStr())) {
            dto.setCatas(vehiclePlatCataBiz.groupCatasByParent(dto.getCatasStr()));
        }
        //设置显示是否有车（通过把时间与位比较从where移动到select）
        //dto.setYearNo4Where(Boolean.TRUE);
        //dto.setWithoutRecordWhere(SYS_TRUE);
        //匹配相交叉的预约记录
        dto.setRecordIntersection(Boolean.TRUE);
        PageDataVO<UsableVehicleModelVO> uvmvpdvs = vehicleBiz.searchUsableModel(dto);
        if(CollUtil.isNotEmpty(uvmvpdvs.getData())){
            uvmvpdvs.getData().forEach(data -> {
                data.setHasVehicle(SYS_FALSE);
//                if(StrUtil.isNotBlank(data.getVehicleIds())) {
//                    String[] strs = StrUtil.split(data.getVehicleIds(), ",");
//                    List<Vehicle> vehicleList = vehicleBiz.selectByWeekend(w -> {
//                        w.andIn(Vehicle::getId, CollUtil.toList(strs));
//                        return w;
//                    });
//                    vehicleList.forEach(vehicle -> {
//                        baseBiz
//                    });
//                }
                RentVehicleBookDTO rbd = new RentVehicleBookDTO();
                rbd.setModelId(data.getVehicleModel().getId());
                rbd.setLimit(20);
                rbd.setPage(1);
                rbd.setParkBranchCompanyId(dto.getStartCompanyId());
                rbd.setStartCompanyId(dto.getStartCompanyId());
                rbd.setEndCompanyId(dto.getEndCompanyId());
                rbd.setBookStartDate(dto.getStartDate());
                rbd.setBookEndDate(dto.getEndDate());
                rbd.setRecordIntersection(Boolean.TRUE);
                rbd.setBookStartDateTime(dto.getStartDateTime());
                rbd.setBookEndDateTime(dto.getEndDateTime());
                rbd.setYearNo4Where(Boolean.TRUE);
                //查询可车辆信息
                PageDataVO<UsableVeicleVO> pageDataVO = vehicleBiz.searchUsableVehicle(rbd);
                if(CollUtil.isNotEmpty(pageDataVO.getData())) {

                    for (UsableVeicleVO usableVeicleVO : pageDataVO.getData()) {

                        //判断是否预定时间内可租
                        usableVeicleVO.setAllowRent(SYS_TRUE);
                        //如果"必须在这时间后预定" 存在 并且 比预定开始时间 要晚，那么不允许预定
                        if(null != usableVeicleVO.getToLiftMustAfterDate() && DateUtil.date(dto.getStartDateTamp()).isBeforeOrEquals(usableVeicleVO.getToLiftMustAfterDate())) {
                            usableVeicleVO.setAllowRent(SYS_FALSE);
                        }

                        //如果"必须在这时间前预定" 存在 并且 比预定结束时间 要早，那么不允许预定
                        if(null != usableVeicleVO.getToReturnMustBeforeDate() && DateUtil.date(dto.getEndDateTamp()).isAfterOrEquals(usableVeicleVO.getToReturnMustBeforeDate())) {
                            usableVeicleVO.setAllowRent(SYS_FALSE);
                        }else {
                            data.setHasVehicle(SYS_TRUE);
                        }

                        String priceStartDateStr = StrUtil.isNotBlank(dto.getPriceStartDate())? dto.getPriceStartDate(): dto.getStartDate();
                        String priceEndDateStr = StrUtil.isNotBlank(dto.getPriceEndDate())? dto.getPriceEndDate(): dto.getEndDate();

                        usableVeicleVO.setPriceDTOS(vehicleHolidayPriceInfoBiz.getSynthesizePrice(usableVeicleVO.getId(), priceStartDateStr, priceEndDateStr, null, usableVeicleVO.getSubordinateBranch()));
                    }
                    data.setUsableVeicleVOList(pageDataVO.getData());
                }
            });
        }
        return ObjectRestResponse.succ(uvmvpdvs);
    }

    /**
     * 可用车辆查询
     *
     * @param dto
     * @return
     */
    @ApiOperation("可用车辆查询")
    @RequestMapping(value = "/rent/usable-vehicle/v2", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<UsableVeicleVO>> rentUsableVehicleV2(UsableVeicleDTO dto) throws Exception {
        //根据时间 获得 可用车辆
        //结合车型
        if (StringUtils.isNotBlank(dto.getCatasStr())) {
            dto.setCatas(vehiclePlatCataBiz.groupCatasByParent(dto.getCatasStr()));
        }

        RentVehicleBookDTO rbd = new RentVehicleBookDTO();
        rbd.setLimit(dto.getLimit());
        rbd.setPage(dto.getPage());
        rbd.setLon(dto.getLon());
        rbd.setLat(dto.getLat());
        rbd.setAddrCity(dto.getAddrCity());
        rbd.setParkBranchCompanyId(dto.getStartCompanyId());
        rbd.setStartCompanyId(dto.getStartCompanyId());
        rbd.setEndCompanyId(dto.getEndCompanyId());
        rbd.setBookStartDate(dto.getStartDate());
        rbd.setBookEndDate(dto.getEndDate());
        rbd.setBookStartDateTime(dto.getStartDateTime());
        rbd.setBookEndDateTime(dto.getEndDateTime());
        rbd.setBookStartDateTimestamp(dto.getStartDateTamp());
        rbd.setBookEndDateTimestamp(dto.getEndDateTamp());
        rbd.setCatas2(dto.getCatas());
        rbd.setGoodsType(dto.getGoodsType());
        rbd.setRecordIntersection(Boolean.FALSE);
        rbd.setYearNo4Where(Boolean.FALSE);
        rbd.setTimeUse(Boolean.TRUE);
        //查询可车辆信息
        PageDataVO<UsableVeicleVO> pageDataVO = vehicleBiz.searchUsableVehicle(rbd);
        if(CollUtil.isNotEmpty(pageDataVO.getData())) {

            for (UsableVeicleVO usableVeicleVO : pageDataVO.getData()) {

                //判断是否预定时间内可租
                usableVeicleVO.setAllowRent(SYS_TRUE);
                //如果"必须在这时间后预定" 存在 并且 比预定开始时间 要晚，那么不允许预定
                if(null != usableVeicleVO.getToLiftMustAfterDate() && DateUtil.date(dto.getStartDateTamp()).isBeforeOrEquals(usableVeicleVO.getToLiftMustAfterDate())) {
                    usableVeicleVO.setAllowRent(SYS_FALSE);
                }

                //如果"必须在这时间前预定" 存在 并且 比预定结束时间 要早，那么不允许预定
                if(null != usableVeicleVO.getToReturnMustBeforeDate() && DateUtil.date(dto.getEndDateTamp()).isAfterOrEquals(usableVeicleVO.getToReturnMustBeforeDate())) {
                    usableVeicleVO.setAllowRent(SYS_FALSE);
                }

                String priceStartDateStr = StrUtil.isNotBlank(dto.getPriceStartDate())? dto.getPriceStartDate(): dto.getStartDate();
                String priceEndDateStr = StrUtil.isNotBlank(dto.getPriceEndDate())? dto.getPriceEndDate(): dto.getEndDate();

                usableVeicleVO.setPriceDTOS(vehicleHolidayPriceInfoBiz.getSynthesizePrice(usableVeicleVO.getId(), priceStartDateStr, priceEndDateStr, null, usableVeicleVO.getSubordinateBranch()));
            }
        }

        return ObjectRestResponse.succ(pageDataVO);
    }

    @ApiOperation("调车申请列表-可用车辆查询")
    @RequestMapping(value = "/rent/apply/usable-vehicle", method = RequestMethod.POST)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<UsableVeicleVO>> applyUsableVehicle(@RequestBody RentVehicleBookDTO rbd) {
        rbd.setRecordIntersection(Boolean.FALSE);
        rbd.setLimit(100);
        rbd.setPage(1);
        rbd.setYearNo4Where(Boolean.FALSE);

        //查询可车辆信息
        PageDataVO<UsableVeicleVO> pageDataVO = vehicleBiz.searchUsableVehicle(rbd);

        if(CollUtil.isNotEmpty(pageDataVO.getData())) {

            for (UsableVeicleVO usableVeicleVO : pageDataVO.getData()) {

                //判断是否预定时间内可租
                usableVeicleVO.setAllowRent(SYS_TRUE);
                //如果"必须在这时间后预定" 存在 并且 比预定开始时间 要晚，那么不允许预定
                if(null != usableVeicleVO.getToLiftMustAfterDate() && DateUtil.parse(rbd.getBookStartDateTime()).isBeforeOrEquals(usableVeicleVO.getToLiftMustAfterDate())) {
                    usableVeicleVO.setAllowRent(SYS_FALSE);
                }

                //如果"必须在这时间前预定" 存在 并且 比预定结束时间 要早，那么不允许预定
                if(null != usableVeicleVO.getToReturnMustBeforeDate() && DateUtil.parse(rbd.getBookEndDateTime()).isAfterOrEquals(usableVeicleVO.getToReturnMustBeforeDate())) {
                    usableVeicleVO.setAllowRent(SYS_FALSE);
                }

            }
        }
        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 后台查询可用车辆(车型)
     *
     * @param dto
     * @return
     */
    @ApiOperation("后台可用车辆查询")
    @RequestMapping(value = "/rent/back-stage/usable-vehicle", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<UsableVehicleModelVO>> rentBgUsableVehicle(UsableVeicleDTO dto) throws Exception {
        //根据时间 获得 可用车辆
        //结合车型
        if (StringUtils.isNotBlank(dto.getCatasStr())) {
            dto.setCatas(vehiclePlatCataBiz.groupCatasByParent(dto.getCatasStr()));
        }
        //设置显示是否有车（通过把时间与位比较从where移动到select）
        dto.setYearNo4Where(Boolean.TRUE);
        //dto.setUseType(null);
        return ObjectRestResponse.succ(vehicleBiz.searchUsableModelBackStage(dto));
    }

    /**
     * 热门车型
     *
     * @param dto
     * @return
     */
    @ApiOperation("热门车型")
    @RequestMapping(value = "/rent/hot-vehicle", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<UsableVehicleModelVO>> hotVehicle(HotVeicleDTO dto) throws Exception {
        return ObjectRestResponse.succ(vehicleBiz.hotModel(dto));
    }

    /**
     * 租车触发的申请预定车辆
     *
     * @param dto
     * @return
     */
    @ApiOperation("租车触发的申请预定车辆")
    @RequestMapping(value = "/rent/book/vehicle", method = RequestMethod.POST)
    @IgnoreClientToken
    @IgnoreUserToken
    public ObjectRestResponse<VehicleBookRecord> rentApplyVehicle(@RequestBody RentVehicleBookDTO dto) throws Exception {
        //默认USER_APP 预约
        Integer operatorId = USER_APP;
        String userName = dto.getUserName();
        String bookVehicleId;
        if(StrUtil.isNotBlank(dto.getNumberPlate())) {
            Vehicle vehicle = vehicleBiz.selectOne(new Vehicle(){{
                setNumberPlate(dto.getNumberPlate());
                setIsDel(SYS_FALSE);
            }});
            bookVehicleId = vehicle.getId();
        }else if(null != dto.getVehicleId()){
            bookVehicleId = dto.getVehicleId();
        }else {
            dto.setLimit(1);
            dto.setPage(1);
            dto.setParkBranchCompanyId(dto.getLiftCompany());
            dto.setStartCompanyId(dto.getLiftCompany());
            dto.setEndCompanyId(dto.getEndCompanyId());
            //查询可车辆信息
            PageDataVO<UsableVeicleVO> pageDataVO = vehicleBiz.searchUsableVehicle(dto);
            if (pageDataVO.getData().size() <= 0 && (dto.getMemberUse() == null || dto.getMemberUse().equals(VehicleMemberType.NO.getCode()))) {

                throw new BaseException(ResultCode.NOTEXIST_CODE, new HashSet<String>(){{
                    add("可用车辆不存在");
                }});
            } else  if (pageDataVO.getData().size() <= 0 && (dto.getMemberUse() == null ||!dto.getMemberUse().equals(VehicleMemberType.NO.getCode()))) {
                throw new BaseException(ResultCode.NOTEXIST_CODE, new HashSet<String>(){{
                    add("仅剩托管车辆，无法使用免费天数，请关闭会员特权");
                }});
            }
            bookVehicleId = pageDataVO.getData().get(0).getId();
        }
        //判断是否为今天，如果是则设置为30秒后开始 防止预约开始时间比当前时间 要 前
        if(DateUtil.today().equals(dto.getBookStartDate())) {
            LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneOffset.ofHours(8)).plusSeconds(30L);
            dto.setBookStartDate(DateTimeFormatter.ofPattern(DATE_TIME_LINE).format(ldt));
        }else {
            dto.setBookStartDate(dto.getBookStartDateTime());
        }
        dto.setBookEndDate(dto.getBookEndDateTime());
        BookVehicleVO bookVehicleVo = BeanUtil.toBean(dto, BookVehicleVO.class);
        bookVehicleVo.setBookType(BookType.USER_RENT.getCode());
        bookVehicleVo.setVehicleId(bookVehicleId);
        if(null != dto.getStatus()) {
            bookVehicleVo.setStatus(dto.getStatus());
        }else {
            bookVehicleVo.setStatus(VehicleBookRecordStatus.APPLY.getCode());
        }
        VehicleBookRecord vehicleBookRecord = baseBiz.applyVehicle(operatorId, bookVehicleVo, userName);
        return ObjectRestResponse.succ(vehicleBookRecord);
    }

    @GetMapping(value = "/app/unauth/v2/getPriceByVehicle")
    @IgnoreUserToken
    public  ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> getByVehicleIdV2(String vehicleId, String startDate, String endDate, Long startDateTemp, Long endDateTemp) {
//        if(null != startDateTemp) {
//            startDate = DateUtil.date(startDateTemp).toString();
//        }
//        if(null != endDateTemp) {
//            endDate = DateUtil.date(endDateTemp).toString();
//        }
        return ObjectRestResponse.succ(vehicleHolidayPriceInfoBiz.getSynthesizePrice(vehicleId, startDateTemp, endDateTemp, getCurrentUserIdInt()));
    }

    @GetMapping(value = "v2/getPriceByVehicleFeign")
    @IgnoreUserToken
    public  ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> getByVehicleIdFeignV2(String vehicleId, Long startDateTemp, Long endDateTemp, Integer userId) {

        List<VehicleModelCalendarPriceDTO> list = vehicleHolidayPriceInfoBiz.getSynthesizePrice(vehicleId, startDateTemp, endDateTemp, userId);
        Vehicle vehicle = vehicleBiz.selectOne(new Vehicle(){{
            setId(vehicleId);
        }});
        List<VehicleModelCalendarPriceDTO> list2 = CollUtil.newArrayList();
        if(list.size() > 0) {
            Integer cycle = 0;
            if(Vehicle.PRICE_TYPE_HOUR ==  vehicle.getPriceType()) {
                cycle = getIncludeHours(startDateTemp, endDateTemp);
            }else {
                cycle = getIncludeDays(startDateTemp, endDateTemp);
            }

            for(int i = 0; i < cycle; i++) {
                list2.add(list.get(i));
            }
        }
        return ObjectRestResponse.succ(list2);
    }

//    public List<VehicleModelCalendarPriceDTO> getSynthesizePrice (String vehicleId, Long startDateTemp, Long endDateTemp, Integer userId) {
//        List<VehicleModelCalendarPriceDTO> priceDTOS = CollUtil.newArrayList();
//        String startDate = DateUtil.date(startDateTemp).toString();
//        String endDate = DateUtil.date(endDateTemp).toString();
//        cn.hutool.core.date.DateTime beginOfStartDate = DateUtil.beginOfDay(DateUtil.parse(startDate));
//        cn.hutool.core.date.DateTime endOfEndDate = DateUtil.endOfDay(DateUtil.parse(endDate));
//        //获取基本和周末价格company_info
//        Vehicle vehicle = vehicleBiz.selectOne(new Vehicle(){{
//            setId(vehicleId);
//        }});
//
//        if(null == vehicle) {
//            return CollUtil.newArrayList();
//        }
//
//        if(Vehicle.PRICE_TYPE_HOUR ==  vehicle.getPriceType()) {
//            //Date currentDate = DateUtil.beginOfDay(DateUtil.parse(startDate));
//            for(cn.hutool.core.date.DateTime currentDate = DateUtil.truncate(DateUtil.parse(startDate), HOUR_OF_DAY);
//                (currentDate.isAfterOrEquals(beginOfStartDate) && currentDate.isBeforeOrEquals(endOfEndDate));
//                currentDate = DateUtil.offsetHour(currentDate, 1)) {
//                cn.hutool.core.date.DateTime finalCurrentDate = currentDate;
//                VehicleModelCalendarPriceDTO dto = new VehicleModelCalendarPriceDTO(){{
//                    setDate(DateUtil.beginOfDay(finalCurrentDate));
//                }};
//                if(currentDate.isWeekend()) {
//                    dto.setNo_discount_price(vehicle.getHolidayPrice());
//                    dto.setPrice(vehicle.getHolidayPrice());
//                    dto.setFreeDays(1);
//                }else {
//                    dto.setNo_discount_price(vehicle.getPrice());
//                    dto.setPrice(vehicle.getPrice());
//                    dto.setFreeDays(1);
//                }
//
//                priceDTOS.add(dto);
//            }
//        }else {
//            //Date currentDate = DateUtil.beginOfDay(DateUtil.parse(startDate));
//            for(cn.hutool.core.date.DateTime currentDate = DateUtil.beginOfDay(DateUtil.parse(startDate));
//                (currentDate.isAfterOrEquals(beginOfStartDate) && currentDate.isBeforeOrEquals(endOfEndDate));
//                currentDate = DateUtil.offsetDay(currentDate, 1)) {
//                cn.hutool.core.date.DateTime finalCurrentDate = currentDate;
//                VehicleModelCalendarPriceDTO dto = new VehicleModelCalendarPriceDTO(){{
//                    setDate(DateUtil.beginOfDay(finalCurrentDate));
//                }};
//                if(currentDate.isWeekend()) {
//                    dto.setNo_discount_price(vehicle.getHolidayPrice());
//                    dto.setPrice(vehicle.getHolidayPrice());
//                    dto.setFreeDays(1);
//                }else {
//                    dto.setNo_discount_price(vehicle.getPrice());
//                    dto.setPrice(vehicle.getPrice());
//                    dto.setFreeDays(1);
//                }
//
//                priceDTOS.add(dto);
//            }
//
//        }
//
//        //获取节假日价格
////        List<VehicleHolidayPriceInfo> vehicleHolidayPriceInfoList = getByVehicleIdAndDate(vehicleId, startDate, endDate);
////
////        if(CollUtil.isNotEmpty(vehicleHolidayPriceInfoList)) {
////            vehicleHolidayPriceInfoList.forEach(info -> {
////                priceDTOS.forEach(tmpDto -> {
////                    if(DateUtil.isSameDay(info.getFestivalDate(), tmpDto.getDate())) {
////                        tmpDto.setNo_discount_price(info.getRentPrice());
////                        tmpDto.setPrice(info.getRentPrice());
////                        tmpDto.setFreeDays(info.getRentFreeDay());
////                    }
////                });
////            });
////        }
//
//
//        //获取会员折扣
//        //查询车辆信息
////        Vehicle vehicle = vehicleBiz.selectById(vehicleId);
//        //查询会员信息
//        //默认折扣
//        Integer discount = DEFAULT_DISCOUNT;
//        //会员默认等级
//        Integer memberLevel = DEFAULT_MEMBER_LEVEL;
//        Integer memberType = DEFAULT_MEMBER_TYPE;
//        if (Objects.nonNull(userId)) {
//            BaseUserMember baseUserMember = userFeign.findBaseUserMemberByUserId(userId.intValue());
//            log.info("用户会员信息:【{}】",baseUserMember);
//            discount = baseUserMember == null ? discount : baseUserMember.getDiscount();
//            memberLevel = baseUserMember == null ? memberLevel : baseUserMember.getMemberLevel();
//            memberType = baseUserMember == null ? memberType : baseUserMember.getMemberType();
//        }
//
//        //非会员禁用 非无会员
//        if(vehicle.getMemberUse() != MEMBER_TYPE_FORBID && DEFAULT_MEMBER_TYPE != memberType) {
//            //判断 允许所有会员，或者 memberType 和 车辆memberUse 相等
//            if(vehicle.getMemberUse().equals(MEMBER_TYPE_ALL) || (vehicle.getMemberUse().equals(memberType))) {
//                //设置会员价格
//                Integer finalDiscount = discount;
//                priceDTOS.forEach(dto -> {
//                    dto.setPrice(dto.getNo_discount_price()
//                            .multiply(new BigDecimal(""+ finalDiscount)
//                                    .divide(new BigDecimal("100"))));
//                });
//            }
//        }
//
//        return priceDTOS;
//    }

    @GetMapping(value = "/app/unauth/getDayCalendarPrice")
    @IgnoreUserToken
    public  ObjectRestResponse<List<CalendarPriceChwDTO>> getDayCalendarPrice(DayCalendarDTO dto) {
        return ObjectRestResponse.succ(getChwDayCalendarPrice(dto));
    }

    /**获取价格日历**/
    public List<CalendarPriceChwDTO> getChwDayCalendarPrice (DayCalendarDTO dto) {
        //根据时间获取预约记录 bookinfo
            //转换为月份
        DateTime startDate = DateUtil.parseDateTime(dto.startDate);
        DateTime endDate = DateUtil.parseDateTime(dto.endDate);
        String startMonth = StrUtil.subBefore(startDate.toDateStr(), "-", true);
        String endMonth = StrUtil.subBefore(endDate.toDateStr(), "-", true);

        List<VehicleBookInfo> list = vehicleBookInfoBiz.selectByWeekend(w -> {
            w
            .andEqualTo(VehicleBookInfo::getVehicle, dto.vehicleId)
            .andGreaterThanOrEqualTo(VehicleBookInfo::getYearMonth, startMonth)
            .andLessThanOrEqualTo(VehicleBookInfo::getYearMonth, endMonth)
            ;
            return w;
        }, " `year_month` asc ");
        List<CalendarPriceChwDTO> list2 = CollUtil.newArrayList();

        list.forEach(info -> {
            //月第一天
            DateTime firstDay = DateUtil.parseDate(info.getYearMonth()+ "-01");
            //月总天数
            Integer monthDays = DateUtil.lengthOfMonth(firstDay.monthBaseOne(), firstDay.isLeapYear());
            //与运算
            String monthStr = NumberUtil.getBinaryStr(info.getBookedDate());
            int start = 0;
            if(firstDay.month() == startDate.month() ) {
                start = startDate.dayOfMonth() - 1;
            }
            if(firstDay.month() == endDate.month()) {
                monthDays = endDate.dayOfMonth();
            }

            for(int i = start; i < monthDays; i++) {
                int finalI = i;
                CalendarPriceChwDTO calendarPriceChwDTO = new CalendarPriceChwDTO(){{
                    setDateStr(DateUtil.offsetDay(firstDay, finalI).toDateStr());
                    setAllowRent(SYS_FALSE);
                }};
                if(i > monthStr.length() || !StrUtil.equalsCharAt(monthStr, monthStr.length() - i - 1, '1')) {
                    calendarPriceChwDTO.setAllowRent(SYS_TRUE);
                }
                list2.add(calendarPriceChwDTO);
            }
        });

        return list2;
    }

    @Data
    public static class CalendarPriceChwDTO {
        private String dateStr;
        private Integer allowRent;
    }

    @Data
    public static class DayCalendarDTO {
        String vehicleId;
        String startDate;
        String endDate;
//        Integer userId;
//        Integer startCompanyId;
//        Integer endCompanyId;
    }

}
