package com.xxfc.platform.vehicle.mapper;


import com.xxfc.platform.vehicle.entity.VehiclePublishReceive;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishReceiveDTO;
import com.xxfc.platform.vehicle.pojo.vo.ReceiveVo;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishGoodsVo;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishReceiveVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public interface VehiclePublishReceiveMapper extends Mapper<VehiclePublishReceive>, SelectByIdListMapper<VehiclePublishReceive,Integer> {


    List<VehiclePublishReceiveVo> selectList(VehiclePublishReceiveDTO receiveDTO);

    void  updReceiveById(VehiclePublishReceiveDTO receiveDTO);

    String getOrderNoStr(@Param("publishOrderNo") String publishOrderNo,@Param("ids")List<Integer> ids);

    List<VehiclePublishReceiveVo> getListByUserId(VehiclePublishFindDTO publishFindDTO);

    List<ReceiveVo> selectListByReceive(VehiclePublishFindDTO publishFindDTO);

    List<VehiclePublishGoodsVo> getListByNumber(@Param("receiveOrderNo") String receiveOrderNo);


    @Select("SELECT * FROM vehicle_publish_receive \n" +
            "WHERE vehicle_id = #{vehicleId} and `status` in (0,1,3)")
    VehiclePublishReceive getReceivByVehicleId(@Param("vehicleId")String vehicleId);

}