package com.xxfc.platform.vehicle.entity;

import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

@Data
@Table(name = "vehicle_apply")
public class VehicleApply {
    /**
     * 主键(uuid)
     */
    @Id
    private Integer id;



    @Column(name = "vehicle_id")
    @ApiModelProperty("商品id")
    private String vehicleId;


    /**
     * 车牌号，空字符串-没有
     */
    @Column(name = "number_plate")
    private String numberPlate;



    @ApiModelProperty("商品名称")
    private String name;



    @Column(name = "goods_type")
    @ApiModelProperty("商品类型 1--房车；2--机车；3--游艇")
    private Integer goodsType;




    @Column(name = "brand_id")
    @ApiModelProperty("品牌id")
    private Integer brandId;



    @Column(name = "category_id")
    @ApiModelProperty("型号id")
    private Integer categoryId;

    /**
     * 所属分支机构（id）
     */
    @Column(name = "subordinate_branch")
    private Integer subordinateBranch;



    @ApiModelProperty("封面")
    private String cover;


    @ApiModelProperty("banner图，逗号隔开")
    private String images;



    @Column(name = "price_type")
    @ApiModelProperty("价格类型：1-按天；2-按小时")
    private Integer priceType;



    @ApiModelProperty("价格")
    private BigDecimal price;



    @Column(name = "holiday_price")
    @ApiModelProperty("假日价格")
    private BigDecimal holidayPrice;



    @Column(name = "deposit_type")
    @ApiModelProperty("押金类型：1-线上；2-线下")
    private Integer depositType;



    @ApiModelProperty("押金")
    private BigDecimal deposit;



    @Column(name = "vio_deposit")
    @ApiModelProperty("违章押金")
    private BigDecimal vioDeposit;


    /**
     * 备注信息
     */
    private String remark;


    @ApiModelProperty("实物图片(逗开隔开)")
    private String picture;



    @ApiModelProperty("商品标签(逗号隔开)")
    private String tags;




    @Column(name = "form_type")
    @ApiModelProperty("表单提交类型：1-申请入驻：2-修改信息")
    private Integer formType;


    @Column(name = "extension_list")
    @ApiModelProperty("扩展信息list")
    private String extensionList;



    @Column(name = "change_json")
    @ApiModelProperty("改变的json")
    private String changeJson;


    @Column(name = "apply_status")
    @ApiModelProperty("状态：0-待审核；1-审核成功；2-驳回")
    private Integer applyStatus;



    @ApiModelProperty("失败原因")
    private String reason;


    @Column(name = "crt_time")
    private Long crtTime;


    @Column(name = "upd_time")
    private Long updTime;



    @Column(name = "is_del")
    @ApiModelProperty("是否删除：0-正常；1-删除")
    private Integer isDel;


    @Column(name = "vin")
    @ApiModelProperty("车架号")
    private String vin;



    @Column(name = "engine_num")
    @ApiModelProperty("发动机号")
    private String engineNum;

    @Transient
    @ApiModelProperty("扩展信息list")
    private List<VehicleExtensionVO> extensionVOS;









}