package com.xxfc.platform.im.biz;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.dto.MsgTypeEnum;
import com.xxfc.platform.im.dto.UpdateTypeEnum;
import com.xxfc.platform.im.entity.ImComment;
import com.xxfc.platform.im.entity.ImQuestion;
import com.xxfc.platform.im.mapper.ImCommentMapper;
import com.xxfc.platform.universal.feign.MQSenderFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ImCommentBiz extends BaseBiz<ImCommentMapper, ImComment> {

    @Autowired
    ImQuestionBiz imQuestionBiz;
    @Autowired
    UserBiz userBiz;
    @Autowired
    MQSenderFeign mqSenderFeign;
    /**
     * 添加评论
     *
     * @param imComment
     * @return
     */
    public ObjectRestResponse add(ImComment imComment) {
        AppUserDTO appUserDTO = userBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        imComment.setUserId(Long.parseLong(appUserDTO.getImUserid() + ""));
        imComment.setNickname(appUserDTO.getNickname());
        imComment.setPicUrl(appUserDTO.getHeadimgurl());
        if (imComment == null || imComment.getQuestionId() == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        ImQuestion imQuestion = imQuestionBiz.selectById(imComment.getQuestionId());
        if (imQuestion == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        insertSelective(imComment);
        ImQuestion newValue = imQuestionBiz.selectById(imComment.getQuestionId());
        //修改评论数
        imQuestionBiz.update(imComment.getQuestionId(), MsgTypeEnum.comment, UpdateTypeEnum.add);
        //评论添加积分
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userId", appUserDTO.getUserid());
        jsonObject.put("channelId", newValue.getId());
        jsonObject.put("integralRuleCode", "COMMENTPUBLISH");
        mqSenderFeign.sendMessage(RabbitConstant.INTEGRAL_TOPIC, RabbitConstant.INTEGRAL_ROUTING_KEY, jsonObject.toJSONString());
        return ObjectRestResponse.succ();
    }

    /**
     * 删除评论
     *
     * @param imComment
     * @return
     */
    public ObjectRestResponse deleteById(ImComment imComment) {
        AppUserDTO appUserDTO = userBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        if (imComment == null || imComment.getId() == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        ImComment oldValue = mapper.selectByPrimaryKey(imComment);
        if (oldValue == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        oldValue.setIsDel(true);
        updateSelectiveByIdRe(oldValue);
        imQuestionBiz.update(oldValue.getQuestionId(), MsgTypeEnum.comment, UpdateTypeEnum.subtraction);
        return ObjectRestResponse.succ();
    }

}
