package com.xxfc.platform.activity.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 优惠券表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 14:34:49
 */
@Data
@Table(name = "coupon")
public class Coupon implements Serializable {
	private static final long serialVersionUID = 1L;

	public static final Integer CHANNEL_ALL = 0;
	public static final Integer CHANNEL_RENT = 1;
	public static final Integer CHANNEL_TOUR = 2;
	public static final Integer CHANNEL_CAMPSITE = 3;
	public static final Integer CHANNEL_MEMBER = 4;

	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元
     */
    @Column(name = "title")
	@ApiModelProperty(value = "优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元")
    private String title;

	@Column(name = "subtitle")
	@ApiModelProperty(value = "副标题")
	private String subtitle;

	    /**
     *  图片
     */
    @Column(name = "icon")
	@ApiModelProperty(value = "图片")
    private String icon;
	
	    /**
     *  可用于：10店铺优惠券 11新人店铺券  20商品优惠券  30类目优惠券  60平台优惠券 61新人平台券
     */
    @Column(name = "used")
	@ApiModelProperty(value = "可用于：10店铺优惠券 11新人店铺券  20商品优惠券  30类目优惠券  60平台优惠券 61新人平台券")
    private Integer used;
	
	    /**
     *  0-全平台；1-租车；2-旅游；3-营地；4--会员; 5-机车；6-游艇
     */
    @Column(name = "channel")
	@ApiModelProperty(value = "0-全平台；1-租车；2-旅游；3-营地；4--会员; 5-机车；6-游艇")
    private Integer channel;
	
	    /**
     *  0-普通用户；1-会员用户
     */
    @Column(name = "user_type")
	@ApiModelProperty(value = "0-普通用户；1-会员用户")
    private Integer userType;
	
	    /**
     *  1满减券 2叠加满减券 3无门槛券（需要限制大小）
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1满减券 2叠加满减券 3无门槛券（需要限制大小）")
    private Integer type;
	
	    /**
     *  1可用于特价商品 2不能  默认不能(商品优惠卷除外)
     */
    @Column(name = "with_special")
	@ApiModelProperty(value = "1可用于特价商品 2不能  默认不能(商品优惠卷除外)")
    private Integer withSpecial;
	
	    /**
     *  店铺或商品流水号
     */
    @Column(name = "with_sn")
	@ApiModelProperty(value = "店铺或商品流水号")
    private String withSn;
	
	    /**
     *  满多少金额
     */
    @Column(name = "with_amount")
	@ApiModelProperty(value = "满多少金额")
    private BigDecimal withAmount;
	
	    /**
     *  用券抵扣金额
     */
    @Column(name = "used_amount")
	@ApiModelProperty(value = "用券抵扣金额")
    private BigDecimal usedAmount;
	
	    /**
     *  配额：发券数量
     */
    @Column(name = "quota")
	@ApiModelProperty(value = "配额：发券数量")
    private Integer quota;
	
	    /**
     *  每人限领次数
     */
    @Column(name = "limit_collar")
	@ApiModelProperty(value = "每人限领次数")
    private Integer limitCollar;
	
	    /**
     *  已领取的优惠券数量
     */
    @Column(name = "take_count")
	@ApiModelProperty(value = "已领取的优惠券数量")
    private Integer takeCount;
	
	    /**
     *  已使用的优惠券数量
     */
    @Column(name = "used_count")
	@ApiModelProperty(value = "已使用的优惠券数量")
    private Integer usedCount;
	
	    /**
     *  发放开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "发放开始时间")
    private Long startTime;
	
	    /**
     *  发放结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "发放结束时间")
    private Long endTime;
	
	    /**
     *  时效:1绝对时效（领取后XXX-XXX时间段有效）  2相对时效（领取后N天有效）3永久有效
     */
    @Column(name = "valid_type")
	@ApiModelProperty(value = "时效:1绝对时效（领取后XXX-XXX时间段有效）  2相对时效（领取后N天有效）3永久有效")
    private Integer validType;
	
	    /**
     *  使用开始时间
     */
    @Column(name = "valid_start_time")
	@ApiModelProperty(value = "使用开始时间")
    private Long validStartTime;
	
	    /**
     *  使用结束时间
     */
    @Column(name = "valid_end_time")
	@ApiModelProperty(value = "使用结束时间")
    private Long validEndTime;
	
	    /**
     *  自领取之日起有效天数
     */
    @Column(name = "valid_days")
	@ApiModelProperty(value = "自领取之日起有效天数")
    private Integer validDays;
	
	    /**
     *  1生效 2失效 3已结束
     */
    @Column(name = "status")
	@ApiModelProperty(value = "1生效 2失效 3已结束")
    private Integer status;
	
	    /**
     *  跳转链接
     */
    @Column(name = "url")
	@ApiModelProperty(value = "跳转链接")
    private String url;
	
	    /**
     *  创建人
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建人")
    private Integer crtUser;
	
	    /**
     *  创建人名称
     */
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建人名称")
    private String crtName;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新时间")
    private Integer updUser;
	
	    /**
     *  更新人名称
     */
    @Column(name = "upd_name")
	@ApiModelProperty(value = "更新人名称")
    private String updName;
	
	    /**
     *  创建时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long updTime;
	
	/**
     *  是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;

	/**
	 *  可使用门店ids
	 */
	@Column(name = "company_ids")
	@ApiModelProperty(value = "可使用门店ids")
	private String companyIds;

	/**
	 *  是否可领取；0-否；1-是
	 */
	@Column(name = "is_led")
	@ApiModelProperty(value = "是否可领取；0-否；1-是")
	private Integer isLed;

    /**
     *  平台类型 1--运营平台；2--商家平台
     */
    @Column(name = "biz_type")
    @ApiModelProperty(value = "平台类型 1--运营平台；2--商家平台")
    private Integer bizType;
}
