package com.xxfc.platform.uccn.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.uccn.dto.FriendLinkDTO;
import com.xxfc.platform.uccn.dto.FriendLinkFindDTO;
import com.xxfc.platform.uccn.entity.FriendLink;
import com.xxfc.platform.uccn.mapper.FriendLinkMapper;
import com.xxfc.platform.uccn.vo.FriendLinkAdminVO;
import com.xxfc.platform.uccn.vo.FriendLinkVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/6 10:57
 */
@Service
public class FriendLinkBiz extends BaseBiz<FriendLinkMapper, FriendLink> {

    /**
     * 保存编辑
     * @param friendLinkDTO
     */
    public void saveFriendLink(FriendLinkDTO friendLinkDTO) {
        FriendLink friendLink = new FriendLink();
        BeanUtils.copyProperties(friendLinkDTO, friendLink);
        if (friendLink.getOnState()){
            friendLink.setPublishTime(Instant.now().toEpochMilli());
        }
        if (Objects.isNull(friendLinkDTO.getId())) {
            friendLink.setCrtTime(Instant.now().toEpochMilli());
            friendLink.setIsDel(false);
            mapper.insertSelective(friendLink);
        }else {
            friendLink.setUpdTime(Instant.now().toEpochMilli());
            mapper.updateByPrimaryKeySelective(friendLink);
        }
    }

    /**
     * 上下架
     * @param id
     */
    public void  updateFriendLinkOnStateById(Long id,Boolean onState){
        FriendLink friendLink = FriendLink.builder().id(id).onState(onState).updTime(Instant.now().toEpochMilli()).build();
        if (onState){
            friendLink.setPublishTime(Instant.now().toEpochMilli());
        }
        mapper.updateByPrimaryKeySelective(friendLink);
    }

    /**
     * 删除
     * @param id
     */
    public void deleteFriendLinkById(Long id){
        FriendLink friendLink = FriendLink.builder().id(id).updTime(Instant.now().toEpochMilli()).isDel(true).build();
        mapper.updateByPrimaryKeySelective(friendLink);
    }

    /**
     * 根据id查询
     * @param id
     * @return
     */
    public FriendLinkDTO findFriendLinkById(Long id){
        FriendLinkDTO friendLinkDTO = FriendLinkDTO.builder().build();
        FriendLink friendLink = mapper.selectByPrimaryKey(id);
        if (Objects.isNull(friendLink)){
            return friendLinkDTO;
        }
        BeanUtils.copyProperties(friendLink,friendLinkDTO);
        return friendLinkDTO;
    }


    public List<FriendLinkVO> listFriendLinkByPlatform(Integer platform){
        List<FriendLinkVO> friendLinkVOS = new ArrayList<>();
        Example example = new Example(FriendLink.class);
        example.setOrderByClause("rank DESC,publish_time DESC");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        criteria.andEqualTo("onState",true);
        criteria.andIn("platform", Arrays.asList(platform,0));
        criteria.andNotEqualTo("linkUrl","");
        List<FriendLink> friendLinks = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(friendLinks)){
            return friendLinkVOS;
        }
        friendLinkVOS = JSON.parseObject(JSON.toJSONString(friendLinks), new TypeReference<List<FriendLinkVO>>() {
        });
        return friendLinkVOS;
    }

    public PageDataVO<FriendLinkAdminVO> listFriendLinkWithPage(FriendLinkFindDTO friendLinkFindDTO){
        PageDataVO<FriendLinkAdminVO> pageDataVO = new PageDataVO<>();
        Example example = new Example(FriendLink.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (!StringUtils.isEmpty(friendLinkFindDTO.getName())){
            criteria.andLike("name",String.format("%%%s%%",friendLinkFindDTO.getName().trim()));
        }
        if (Objects.nonNull(friendLinkFindDTO.getOnState())){
            criteria.andEqualTo("onState",friendLinkFindDTO.getOnState());
        }
        PageDataVO<FriendLink> friendLinkPageDataVO = PageDataVO.pageInfo(friendLinkFindDTO.getPage(),friendLinkFindDTO.getLimit(),()->mapper.selectByExample(example));
        List<FriendLink> data = friendLinkPageDataVO.getData();
        if (CollectionUtils.isEmpty(data)){
            return pageDataVO;
        }

        List<FriendLinkAdminVO> friendLinkAdminVOS = new ArrayList<>();
        FriendLinkAdminVO friendLinkAdminVO;
        for (FriendLink friendLink : data) {
             friendLinkAdminVO = new FriendLinkAdminVO();
            BeanUtils.copyProperties(friendLink,friendLinkAdminVO);
            friendLinkAdminVOS.add(friendLinkAdminVO);
        }
        pageDataVO.setData(friendLinkAdminVOS);
        pageDataVO.setPageSize(friendLinkPageDataVO.getPageSize());
        pageDataVO.setPageNum(friendLinkPageDataVO.getPageNum());
        pageDataVO.setTotalPage(friendLinkPageDataVO.getTotalPage());
        pageDataVO.setTotalCount(friendLinkPageDataVO.getTotalCount());

        return pageDataVO;
    }
}
