package com.xxfc.platform.activity.config;

import org.redisson.api.*;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/20 16:51
 */
@Component
public class RedissonLock {

    @Resource
    private RedissonClient redissonClient;


    /**
     * 获取锁
     * @param key
     * @return
     */
    public RLock getRLock(String key){
        return redissonClient.getLock(key);
    }

    /**
     * 获取读写锁
     * @param key
     * @return
     */
    public RReadWriteLock getRWLock(String key){
        return redissonClient.getReadWriteLock(key);
    }

    /**
     * 获取记数锁
     * @param key
     * @return
     */
    public RCountDownLatch getRCountDownLatch(String key){
        return redissonClient.getCountDownLatch(key);
    }

    /**
     * 获取消息的Topic
     * @param key
     * @return
     */
    public RTopic getRTopic(String key){
        RTopic rTopic =  redissonClient.getTopic(key);
        return rTopic;
    }
}
