package com.github.wxiaoqi.security.common.support.config;

import com.github.wxiaoqi.security.common.support.aop.ValidParamAop;
import org.hibernate.validator.HibernateValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

/**
 * @author libin
 * @version 1.0
 * @description 验证器validator
 * @data 2019/6/13 13:48
 */
@Configuration
public class ValidatorConfig {

    /**
     * 复合类型所用的验证器
     * @return Validator
     */
    @Bean
    public Validator validator(){
        // .failFast( true ) 为设置快速错误模式，默认为false
        ValidatorFactory validatorFactory = Validation.byProvider( HibernateValidator.class )
                .configure()
                .failFast( true )
                .buildValidatorFactory();
        return validatorFactory.getValidator();
    }

    /**
     * 简单类型所用的验证器
     * @return ExecutableValidator
     */
    @Bean
    public ExecutableValidator executableValidator() {
        return validator().forExecutables();
    }

    /**
     * 装配验证器切面
     * @param validator Bean验证器
     * @param executableValidator 简单类型验证器
     * @return ValidParamAop
     */
    @Bean
    public ValidParamAop validAop(Validator validator, ExecutableValidator executableValidator) {
        ValidParamAop validParamAop = new ValidParamAop();
        validParamAop.setValidator(validator);
        validParamAop.setExecutableValidator(executableValidator);
        return validParamAop;
    }
}
