package com.xxfc.platform.uccn.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.uccn.biz.FriendLinkBiz;
import com.xxfc.platform.uccn.dto.FriendLinkDTO;
import com.xxfc.platform.uccn.dto.FriendLinkFindDTO;
import com.xxfc.platform.uccn.vo.FriendLinkAdminVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/6 10:59
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/admin/friend_link")
@Api(tags = "友情链接*后台")
public class FriendLinkAdminController {

     private final FriendLinkBiz friendLinkBiz;

     @ApiOperation("分页")
     @PostMapping("/page")
     public ObjectRestResponse<PageDataVO<FriendLinkAdminVO>> listFriendLinkWithPage(@RequestBody FriendLinkFindDTO friendLinkFindDTO){
          PageDataVO<FriendLinkAdminVO> pageDataVO = friendLinkBiz.listFriendLinkWithPage(friendLinkFindDTO);
          return ObjectRestResponse.succ(pageDataVO);
     }

     @ApiOperation("根据id查询")
     @GetMapping("/{id}")
     public ObjectRestResponse<FriendLinkDTO> findFriendLink(@PathVariable(value = "id") Long id){
          FriendLinkDTO friendLinkDTO = friendLinkBiz.findFriendLinkById(id);
          return ObjectRestResponse.succ(friendLinkDTO);
     }

     @ApiOperation("编辑或保存")
     @PostMapping("/save")
     public ObjectRestResponse<Void> saveFriendLink(@RequestBody FriendLinkDTO friendLinkDTO){
          friendLinkBiz.saveFriendLink(friendLinkDTO);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("上下架")
     @PutMapping("/on_state/{id}/{state}")
     public ObjectRestResponse<Void> updateFriendLinkOnstate(@PathVariable(value = "id") Long id,@PathVariable(value = "state") Boolean state){
          friendLinkBiz.updateFriendLinkOnStateById(id,state);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("删除")
     @DeleteMapping("/{id}")
     public ObjectRestResponse<Void> deleteFriendLink(@PathVariable(value = "id") Long id){
          friendLinkBiz.deleteFriendLinkById(id);
          return ObjectRestResponse.succ();
     }


}
