package com.xxfc.platform.vehicle.rest.admin;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.biz.ImportVehicleDataBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/vehicle/import")
@Slf4j
public class ImportVehicleDataController extends BaseController<ImportVehicleDataBiz> {
    @PostMapping("/excel/import")
    public ObjectRestResponse excelImport(@RequestParam("file")MultipartFile excelFile) throws IOException {

        String filename = excelFile.getOriginalFilename();
        String split = filename.substring(filename.lastIndexOf("."));
        if (".xlsx".equals(split)) {
            ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"文件格式错误,必须为.xlsx文件!!");
        }
        List<List<Object>> excel= ExcelUtil.getReader(excelFile.getInputStream()).read();
        if (excel==null||excel.size()<3) {
            ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"导入文件无数据!!");
        }

        excel.remove(0);
        excel.remove(1);
        log.error(String.valueOf(excel.size()));
        return ObjectRestResponse.succ(baseBiz.parsingUploadedFiles(excel));
    }


}
