package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.ArticleBiz;
import com.xxfc.platform.uccn.entity.Article;
import com.xxfc.platform.uccn.vo.ArticleQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;


/**
 * 文章
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/article")
@Api(tags = {"文章"})
public class ArticleController extends BaseController<ArticleBiz, Article> {

    @GetMapping("/app/unauth/list")
    @ApiOperation(value = "获取文章列表")
    public ObjectRestResponse getArticleList(
            @RequestParam(name = "page", defaultValue = "1") Integer page,
            @RequestParam(name = "limit", defaultValue = "10") Integer limit,
            @RequestParam(name = "type", defaultValue = "1") Integer type) {
        return ObjectRestResponse.succ(baseBiz.getArticleList(page, limit, type));
    }

    @GetMapping("/app/unauth/one")
    @ApiOperation(value = "获取一条数据")
    public ObjectRestResponse getOne(@RequestParam Integer id,
                                     @RequestParam(required = false) Integer urlType) {
       return ObjectRestResponse.succ(baseBiz.getOne(id,urlType));
    }

    /**
     * 随机获取三条数据
     * @param type
     * @param number
     * @param id
     * @return
     */
    @GetMapping("/app/unauth/three")
    @ApiOperation(value = "随机获取三条数据")
    public ObjectRestResponse randomAccessToThreeData(@RequestParam("type") Integer type,
                                                      @RequestParam("number") Integer number,
                                                      @RequestParam("id") Integer id
                                                      ){
        return ObjectRestResponse.succ(baseBiz.getThree(type,number,id));
    }

    @GetMapping("/app/unauth/homePage/{type}")
    @ApiOperation(value = "获取首页文章列表")
    public ObjectRestResponse getHomePageArticle(@PathVariable Integer type){
        return ObjectRestResponse.succ(baseBiz.getHomePageArticle(type));
    }

    @Override
    @PostMapping("/add")
    @ApiOperation(value = "添加")
    public ObjectRestResponse add(@RequestBody Article article){
        baseBiz.add(article);
        return ObjectRestResponse.succ();
    }


    @PostMapping("/all")
    @ApiOperation(value = "获取新闻列表")
    public ObjectRestResponse<Article> findAll(@RequestBody ArticleQuery query){
        return ObjectRestResponse.succ(baseBiz.findAll(query));
    }

    @Override
    @PutMapping("/update")
    @ApiOperation(value = "修改")
    public ObjectRestResponse update(@RequestBody Article article){
        int flag = baseBiz.updateSelectiveByIdRe(article);
        if (flag==1) {
            return ObjectRestResponse.succ();
        }
       return ObjectRestResponse.createDefaultFail();
    }

    @PutMapping("/putaway/{id}")
    @ApiOperation(value = "上架")
    public ObjectRestResponse  putaway(@PathVariable Integer id){
        int flag = baseBiz.putaway(id);
        if (flag==1) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @PutMapping("/soldOut/{id}")
    @ApiOperation(value = "下架")
    public ObjectRestResponse soldOut(@PathVariable Integer id){
        int flag = baseBiz.soldOut(id);
        if (flag==1) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @PutMapping("/remove/{id}")
    @ApiOperation(value = "删除")
    public ObjectRestResponse remove(@PathVariable Integer id){
        int flag = baseBiz.remove(id);
        if (flag==1) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

}
