package com.xxfc.platform.tour.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.List;


/**
 * 旅游商品
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class TourGoodDTO {


	@ApiModelProperty("")
    private Integer id;
	
	//商品名
	@ApiModelProperty(value = "商品名")
    private String name;
	
	//商品封面图
	@ApiModelProperty(value = "商品封面图")
    private String cover;
	
	//商品原价
	@ApiModelProperty(value = "商品原价")
    private BigDecimal price;
	
	//儿童价格
	@ApiModelProperty(value = "儿童价格")
    private BigDecimal childPrice;
	
	//商品浏览量
	@ApiModelProperty(value = "商品浏览量")
    private Integer viewCount;
	
	//商品销售量
	@ApiModelProperty(value = "商品销售量")
    private Integer saleCount;

	//天数
	@ApiModelProperty(value = "天数")
	private Integer number;
	
	//商品描述
	@ApiModelProperty(value = "商品描述")
    private String describe;
	
	//商品详情(行程亮点)
	@ApiModelProperty(value = "商品详情(行程亮点)")
    private String content;
	
	//行程介绍
	@ApiModelProperty(value = "行程介绍")
    private String introduce;

	//费用说明
	@ApiModelProperty(value = "费用说明")
	private String explain;
	
	//排序
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	//状态:0-未发布;1-上架；2-下架
	@ApiModelProperty(value = "状态:0-未发布;1-上架；2-下架")
    private Integer status;

	//是否省外；0-省内；1-省外
	@ApiModelProperty(value = "是否省外；0-省内；1-省外")
	private Integer isOutside;


	//是否推荐:0-未推荐；1-已推荐
	@ApiModelProperty(value = "是否推荐:0-未推荐；1-已推荐")
    private Integer recommend;
	
	//是否会员价:0-否；1-是
	@ApiModelProperty(value = "是否会员价:0-否；1-是")
    private Integer isMember;
	
	//库存
	@ApiModelProperty(value = "库存")
    private Integer stock;
	
	//单位
	@ApiModelProperty(value = "单位")
		private String unit;

	//商品轮播
	@ApiModelProperty(value = "商品轮播")
   List<GoodBannerDTO> bannerDTOS;

   //出发,途径,终点
   @ApiModelProperty(value = "出发,途径,终点")
	List<GoodSiteDTO> siteDTOS;

	//商品规格
	@ApiModelProperty(value = "商品规格")
	List<GoodSpePriceDTO> priceDTOS;

	//商品标签
	@ApiModelProperty(value = "商品标签")
	List<GoodTagDTO> tagDTOS;

	@ApiModelProperty(value = "海报背景")
	private String posterBackground;

}
