package com.xxfc.platform.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;

@Table(name = "deposit_refund_record")
@Data
public class DepositRefundRecord {
    @Id
    private Integer id;

    /**
     * 定损状态：1、押金退还已经发起，2、押金退还已到账，3、违章押金已到账，4、定损中，5、完成定损退还剩余押金，6、剩余押金退还到账，
     */
    private Integer status;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 交还车记录ID
     */
    @Column(name = "crosstown_id")
    private Integer crosstownId;

    /**
     * 退换押金
     */
    private BigDecimal amount;

    /**
     * 剩余押金
     */
    private BigDecimal restAmount;

    /**
     * 总共押金
     */
    private BigDecimal totalAmount;

    /**
     * 是否显示
     */
    private Boolean isshow;
    /**
     * 是否完成
     */
    private Boolean iscomplete;

    /**
     * 违章记录
     */
    @Transient
    OrderViolation orderViolation;
    /**
     * 剩余押金预计到账时间
     */
    @Transient
    Long rentDepositAutoRefundTime;

    /**
     * 客服电话
     */
    @Transient
    private String customerPhone;
}