package com.xxfc.platform.app.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 购房车提交表单
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-09 19:39:47
 */
@Data
@Table(name = "buy_vehicle_form")
public class BuyVehicleForm implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  车型id
     */
    @Column(name = "model_id")
	@ApiModelProperty(value = "车型id")
    private Integer modelId;
	
	    /**
     *  联系人名称
     */
    @Column(name = "contact_name")
	@ApiModelProperty(value = "联系人名称")
    private String contactName;
	
	    /**
     *  联系人电话
     */
    @Column(name = "contact_phone")
	@ApiModelProperty(value = "联系人电话")
    private String contactPhone;
	
	    /**
     *  预约时间
     */
    @Column(name = "book_time")
	@ApiModelProperty(value = "预约时间")
    private Long bookTime;
	
	    /**
     *  公司id
     */
    @Column(name = "company_id")
	@ApiModelProperty(value = "公司id")
    private Integer companyId;
	
	    /**
     *  备注
     */
    @Column(name = "remark")
	@ApiModelProperty(value = "备注")
    private String remark;

	/**
	 *  用户id
	 */
	@Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
	private Integer userId;
}
