package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.entity.Festival;
import com.xxfc.platform.vehicle.mapper.FestivalMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/18 17:31
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class FestivalBiz extends BaseBiz<FestivalMapper,Festival> {

     public void add(Festival festival){
         if (Objects.isNull(festival.getId())){
             festival.setCrtTime(new Date());
             mapper.insertSelective(festival);
         }else {
             mapper.updateByPrimaryKey(festival);
         }
     }

     public void deleteById(Integer festivalId){
         Festival festival = new Festival();
         festival.setId(festivalId);
         mapper.deleteByPrimaryKey(festival);
     }

    public Map<Integer, Festival> findFestivalsByIds(List<Integer> festivalIds) {
         Map<Integer,Festival> festivalMap =  new HashMap<>(20);
        List<Festival> festivals = mapper.selectByIdList(festivalIds);
        if (CollectionUtils.isNotEmpty(festivalIds)){
            festivalMap = festivals.stream().collect(Collectors.toMap(Festival::getId, Function.identity()));
        }
        return festivalMap;
    }
}
