package com.xxfc.platform.order.pojo.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

@Data
public class VehicleItemDTO extends OrderItem {
    public static final int topNum = 2;
    public BigDecimal calculateVehicleUnitPrice(BigDecimal vehicleAmount, BigDecimal metaVehicleAmount, Boolean isSetRealAmount) {
        BigDecimal unitPrice = vehicleAmount.divide(new BigDecimal(getCalculateNum()+ ""), 2, RoundingMode.HALF_UP);
        BigDecimal metaUnitPrice = metaVehicleAmount.divide(new BigDecimal(getCalculateNum()+ ""), 2, RoundingMode.HALF_UP);

        if(isSetRealAmount) {
            setRealAmount(vehicleAmount);
        }

        setUnitPrice(unitPrice);
        setMetaUnitPrice(metaUnitPrice);

        return unitPrice;
    }

    public BigDecimal getCutAmount() {
        List<VehicleModelCalendarPriceDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return super.getCutAmount();
        }
        BigDecimal cutAmount = BigDecimal.ZERO;
        for(int i = 0; i < getCutNum(); i++) {
            cutAmount = cutAmount.add(vmcpds.get(i).getPrice());
        }
        return cutAmount;
    }

    public List<VehicleModelCalendarPriceDTO> getVehicleDetail() {
        if(StrUtil.isBlank(getDetail())) {
            return CollUtil.newArrayList();
        }
        return JSONUtil.toList(JSONUtil.parseArray(getDetail()), VehicleModelCalendarPriceDTO.class);
    }

    public BigDecimal getBuyAmount() {
        List<VehicleModelCalendarPriceDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return super.getBuyAmount();
        }
        BigDecimal buyAmount = BigDecimal.ZERO;
        for(int i = 0; i < getBuyNum(); i++) {
            buyAmount = buyAmount.add(vmcpds.get(i).getPrice());
        }
        return buyAmount;
    }

    public BigDecimal getTopAmount(Integer useDays) {
        List<VehicleModelCalendarPriceDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return getUnitPrice().multiply(new BigDecimal(topNum+ ""));
        }
        BigDecimal topAmount = BigDecimal.ZERO;
        for(int i = useDays; i < getTotalNum(); i++) {
            topAmount = topAmount.add(vmcpds.get(i).getPrice());
        }

        //未用天数 小于 topNum
        if(getTotalNum() - useDays < topNum) {
            Integer residue = getTotalNum() - useDays;
            topAmount = topAmount.add(vmcpds.get(vmcpds.size() - 1).getPrice().multiply(new BigDecimal((topNum - residue) + "")));
        }
        return topAmount;
    }

    public BigDecimal getUsedAmount(Integer useDays) {
        return getUnitPrice().multiply(new BigDecimal(useDays+ ""));
    }

    public BigDecimal getFreeAmount(Integer freeDays) {
        List<VehicleModelCalendarPriceDTO> vmcpds = getVehicleDetail();
        if(CollUtil.isEmpty(vmcpds)){
            return getUnitPrice().multiply(new BigDecimal(freeDays+ ""));
        }
        BigDecimal freeAmount = BigDecimal.ZERO;
        for(int i = 0; i < getBuyNum(); i++) {
            freeAmount = freeAmount.add(vmcpds.get(i).getPrice());
        }
        return freeAmount;
    }
}
