package com.xxfc.platform.vehicle.pojo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xxfc.platform.vehicle.entity.VehicleDepartureLog;
import lombok.Data;

@Data
public class VehicleDepartureLogVo {
    Integer id;
    String vehicleId;
    String use;
    String user;
    String userTel;
    String checkMan;
    String checkManTel;
    String recycleMan;
    String recycleManTel;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    String departureTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    String arrivalTime;
    Integer mileageStart;
    Integer mileageEnd;
    Integer mileage;
    Integer state;
    String numberPlate;
    String departureDay;
    String departureName;
    String arrivalName;
    Integer bookRecordId;

    String illegalPic;

    Integer illegalAmount;
    //出车图片
    String departurePic;
    //收车图片
    String arrivalPic;
    //备注
    String departureRemark;

    String arrivalRemark;

    public VehicleDepartureLog getVehicleDeparture(VehicleDepartureLogVo vehicleDepartureLogVo) {
        VehicleDepartureLog departureLog = new VehicleDepartureLog();
        BeanUtil.copyProperties(vehicleDepartureLogVo, departureLog, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
        return departureLog;
    }

}
