package com.xxfc.platform.uccn.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.uccn.biz.ModelBackgroundBiz;
import com.xxfc.platform.uccn.entity.Model;
import com.xxfc.platform.uccn.vo.ModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("Model")
@Api(tags={"Model后台管理类"})
public class ModelBackgroundController extends BaseController<ModelBackgroundBiz, Model> {

    @GetMapping("/list")
    @ApiOperation(value = "查询模块列表")
    public ObjectRestResponse findList(){
       return ObjectRestResponse.succ(baseBiz.getList());
    }

    @PutMapping("/upd")
    @ApiOperation(value = "修改模块")
    public ObjectRestResponse update(@RequestBody ModelVo modelvo){
        String update = baseBiz.update(modelvo);
        if (update==null) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,update) ;
    }
}
