package com.xxfc.platform.tour.mapper;

import com.xxfc.platform.tour.dto.TourTagDTO;
import com.xxfc.platform.tour.entity.TourTag;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 旅游路线标签
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Repository
public interface TourTagMapper extends Mapper<TourTag> {

    /**
     * 根据热度查询标签
     * @param tag
     * @return
     */
    @Select("select * from tour_tag where is_del=#{isDel} and is_hot=#{isHot} order by rank ASC")
    List<TourTag> findHotListTag(TourTag tag);

    /**
     * 根据删除状态查询标签
     * @param tagBanner
     * @return
     */
    @Select("select * from tour_tag where is_del=#{isDel} order by rank ASC")
    @ResultMap(value = "tourTagMap")
    List<TourTag> findAllByIsDel(TourTag tagBanner);

    /**
     * 根据主要id查询
     * @param id
     * @return
     */
    @Select("select * from tour_tag where id=#{id}")
    @ResultMap(value = "tourTagMap")
    TourTag findById(Integer id);

    /**
     * 保存旅游标签
     * @param tourTag
     * @return
     */
    int save(TourTagDTO tourTag);

    /**
     * 更新旅游标签的 删除状态
     * @param id
     * @param status
     * @return
     */
    @Update("update tour_tag set `is_del`=#{status} where `id`=#{id}")
    int updateTourTagStatusById(@Param("id") Integer id, @Param("status") int status);

    /**
     * 编辑标签
     * @param tourTagDTO
     * @return
     */
    @Update("update tour_tag set `name`=#{name},`img`=#{img},`describe`=#{describe},`link`=#{link}" +
            ",`rank`=#{rank},`upd_time`=#{updTime} where `id`=#{id}")
    int updateTourTag(TourTagDTO tourTagDTO);

    /**
     * 更新标签热度
     * @param id
     * @param state
     * @return
     */
    @Update("update tour_tag set `is_hot`=#{state} where `id`=#{id}")
    int updateTourTagHotSate(@Param("id") Integer id, @Param("state") Integer state);

    /**
     * 检测标签名是否存在
     * @param name
     * @param id
     * @return
     */
    List<TourTag> findByTagName(@Param("name") String name,@Param("id") Integer id);

    /**
     *根据状态查询 标签
     * @param status
     * @return
     */
    @Select("select `id`,`name` from tour_tag where `is_del`=#{status}")
    List<TourTag> selectByStuatus(Integer status);
}
