package com.xxfc.platform.tour.vo;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 出发地址
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class TourDepartVo {



	private Integer id;
	//路线id
	@ApiModelProperty(value = "路线id")
	private Integer goodId;

	//站点名称
	@ApiModelProperty(value = "站点名称")
	private String name;

	//站点地址
	@ApiModelProperty(value = "站点地址")
	private String address;

	//分公司id
	@ApiModelProperty(value = "分公司id")
	private String companyId;

	/**
	 * 地址-省/直辖市(编码)
	 */
	@ApiModelProperty("地址-省/直辖市(编码)")
	private Integer province;

	/**
	 * 地址-省/直辖市(名称)
	 */
	@ApiModelProperty("地址-省/直辖市(名称)")
	private String provinceName;

	/**
	 * 地址-市(编码)
	 */
	@ApiModelProperty("地址-市(编码)")
	private Integer city;

	/**
	 * 地址-市(名称)
	 */
	@ApiModelProperty("地址-市(名称)")
	private String cityName;


	//出发时间
	@ApiModelProperty(value = "出发时间")
	private Long departTime;

	//站点经度
	@ApiModelProperty(value = "站点经度")
	private Double longitude;

	//站点纬度
	@ApiModelProperty(value = "站点纬度")
	private Double latitude;

	//站点介绍
	@ApiModelProperty(value = "站点介绍")
	private String intro;

	//类型
	@ApiModelProperty(value = "类型")
	private Integer type;

	//排序
	@ApiModelProperty(value = "排序")
	private Integer rank;

}
