package com.xxfc.platform.activity.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityManagementBiz;
import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.entity.ActivityManagement;
import com.xxfc.platform.activity.vo.ActivityManagementQuery;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 后台活动管理
 * @author Administrator
 */
@RestController
@RequestMapping("management")
public class ActivityManagementController extends BaseController<ActivityManagementBiz, ActivityManagement> {

    /**
     *  查找全部
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @PostMapping("/activity/findAll")
    public ObjectRestResponse findAll(@RequestBody ActivityManagementQuery query) throws InvocationTargetException, IllegalAccessException {
        PageInfo<ActivityList> pageInfo= baseBiz.selectedActivityManagement(query);
      return ObjectRestResponse.succ(pageInfo);
    }


    /**
     * 查找一条
     * @param activityId
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @GetMapping("getOne/{activityId}")
    public ObjectRestResponse<ActivityManagement> getOne(@PathVariable Integer activityId) throws InvocationTargetException, IllegalAccessException {
        return ObjectRestResponse.succ(getBaseBiz().getOne(activityId));
    }


    /**
     * 修改活动
     * @param activityManagement
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @PutMapping("update")
    public ObjectRestResponse updateActivityManagement(@RequestBody ActivityManagement activityManagement ) throws InvocationTargetException, IllegalAccessException {
        getBaseBiz().updateActivityManagement(activityManagement);
        return ObjectRestResponse.succ();
    }

}
