package com.xxfc.platform.activity.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.entity.HomeActivities;
import com.xxfc.platform.activity.mapper.HomeActivitiesMapper;
import com.xxfc.platform.activity.vo.ActivitiesQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.math.BigInteger;
import java.util.List;
/**
 * @author Administrator
 */
@Service
public class HomeActivitiesBiz extends BaseBiz<HomeActivitiesMapper, HomeActivities> {
    public List<HomeActivities> activities () {
        long currentTime = System.currentTimeMillis();
        Example exa=Example.builder(HomeActivities.class).where(WeekendSqls.<HomeActivities>custom()
                .andEqualTo(HomeActivities::getTimeType,1)
                .andGreaterThanOrEqualTo(HomeActivities::getEndTime,currentTime)
                .andLessThanOrEqualTo(HomeActivities::getStartTime,currentTime)
                .andEqualTo(HomeActivities::getStatus,1)
                .andEqualTo(HomeActivities::getIsDel,0)

        ).orderByAsc("sort").build();
        List<HomeActivities> activityLists = selectByExample(exa);

        Example permanentExa=Example.builder(HomeActivities.class).where(WeekendSqls.<HomeActivities>custom()
                .andEqualTo(HomeActivities::getTimeType,0)
                .andEqualTo(HomeActivities::getStatus,1)
                .andEqualTo(HomeActivities::getIsDel,0)
        ).orderByAsc("sort").build();
        List<HomeActivities> permanentActivityLists = selectByExample(permanentExa);
        activityLists.addAll(permanentActivityLists);
        return activityLists;

    }

    public PageInfo<HomeActivities> getPage (ActivitiesQuery query)  {

        Example exa =new Example(HomeActivities.class);
        Example.Criteria criteria = exa.createCriteria();
        if (StringUtils.isNotBlank(query.getActivitiesName())){
            criteria.andLike("name","%"+query.getActivitiesName()+"%");
        }
        criteria.andEqualTo("isDel",0);
        exa.orderBy("sort").asc();
        PageHelper.startPage(query.getPage(),query.getLimit());
        List<HomeActivities> activityLists = selectByExample(exa);
        return  PageInfo.of(activityLists);
    }

    public void deleteOne(Integer id) {
        HomeActivities homeActivities = selectById(id);
        if (homeActivities.getStatus()==1) {
            throw new BaseException("Please take it off the shelves first");
        }else{
            homeActivities.setIsDel(1);
        }

        updateById(homeActivities);
    }


    @Override
    public int updateSelectiveByIdRe(HomeActivities activityPopup) {
        activityPopup.setUpdTime(BigInteger.valueOf(System.currentTimeMillis()));
        return mapper.updateByPrimaryKeySelective(activityPopup);
    }

    @Override
    public int insertSelectiveRe(HomeActivities activityPopup) {
        activityPopup.setCrtTime(BigInteger.valueOf(System.currentTimeMillis()));
        activityPopup.setSort(0);
        activityPopup.setTimeType(0);
        return mapper.insertSelective(activityPopup);
    }
}
