package com.xxfc.platform.vehicle.mapper;


import com.xxfc.platform.vehicle.entity.CompanyBase;
import com.xxfc.platform.vehicle.pojo.dto.CompanyBaseDetailDTO;
import com.xxfc.platform.vehicle.pojo.vo.CompanyVo;
import org.apache.ibatis.annotations.*;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;


public interface CompanyBaseMapper extends Mapper<CompanyBase> {

    @Select("SELECT cb.name,cb.cover,cb.images,cb.describes,cb.content,cb.province_name AS `provinceName`,cb.city_name AS `cityName`,cb.town_name AS `townName`,bc.addr_detail AS `address`  FROM (SELECT * FROM `company_base` WHERE `id`=#{id}) AS `cb` LEFT JOIN `branch_company` AS `bc` ON bc.company_base_id = cb.id;")
/*    @Results(value = {
            @Result(property = "name",column = "name"),
            @Result(property = "cover",column = "cover"),
            @Result(property = "cover",column = "cover"),
            @Result(property = "provinceName",column = "addr_province"),
            @Result(property = "cityName",column = "addr_city"),
            @Result(property = "townName",column = "addr_town")
    })*/
    @ResultType(value = CompanyBaseDetailDTO.class)
    CompanyBaseDetailDTO findCompanyBaseById(@Param("id") Integer id);

    List<CompanyBase> getList(CompanyVo companyVo);
}