package com.xxfc.platform.vehicle.pojo.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.List;


/**
 * 用车调度申请
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
public class VehicleDispatchInfoVo{


	@ApiModelProperty("主键id")
    private Integer id;


    @ApiModelProperty(value = "账号id")
    private Integer accountId;


    @ApiModelProperty(value = "账号名称")
    private String accountName;


    @ApiModelProperty(value = "申请分公司id")
    private Integer companyId;

    @ApiModelProperty(value = "申请分公司名称")
    private String companyName;

    @ApiModelProperty(value = "车型id")
    private Integer modeId;


	@ApiModelProperty(value = "使用人")
    private String user;


	@ApiModelProperty(value = "使用人电话")
    private String userTel;


    @ApiModelProperty(value = "用车开始时间" )
    private Long startTime;


    @ApiModelProperty(value = "用车结束时间")
    private Long endTime;


    @ApiModelProperty(value = "期望还车公司")
    private Integer wishRetCompany;

    @ApiModelProperty(value = "期望还车公司名称")
    private String wishRetCompanyName;


    @ApiModelProperty(value = "用途(枚举类)")
    private Integer bookType;


    @ApiModelProperty(value = "用途备注")
    private String bookRemark;


    @ApiModelProperty(value = "拒绝原因")
    private String reason;


    @ApiModelProperty(value = "状态：0-申请中；1-已通过；2-拒绝")
    private Integer status;


    @ApiModelProperty(value = "预约ids（逗号隔开）")
    private String recordIds;


    @ApiModelProperty(value = "通过审核时间")
    private Long statusTime;


	@ApiModelProperty(value = "创建时间")
    private Long crtTime;
	


	@ApiModelProperty(value = "更新时间")
    private Long updTime;


    @ApiModelProperty(value = "删除状态 0：有效 1：删除")
    private Integer isdel;


   @ApiModelProperty(value = "调度申请用车详情")
   List<VehiclDispatchRecordVo> dispatchRecords;
	

}
