package com.xxfc.platform.vehicle.pojo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

@Data
public class UsableVeicleDTO extends PageParam {
        public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        @ApiModelProperty("城市")
        Integer addrCity;
        @ApiModelProperty("经度")
        Double lon;
        @ApiModelProperty("纬度")
        Double lat;
        @ApiModelProperty(hidden = true)
        String startDate;
        @ApiModelProperty(hidden = true)
        String endDate;
        @ApiModelProperty(hidden = true)
        String startDateExtend;
        @ApiModelProperty(hidden = true)
        String endDateExtend;
        @ApiModelProperty("开始时间戳")
        Long startDateTamp;
        @ApiModelProperty("结束时间戳")
        Long endDateTamp;
        @ApiModelProperty("开始价格")
        String priceStart;
        @ApiModelProperty("结束价格")
        String priceEnd;
        @ApiModelProperty("分类逗号分割")
        String catasStr;
        @ApiModelProperty(value = "分类列表", hidden = true)
        Map<Integer, List<VehiclePlatCata>> catas;
        @ApiModelProperty("停靠公司")
        Integer parkBranchCompanyId;

        @ApiModelProperty("开始公司Id")
        Integer startCompanyId;

        @ApiModelProperty("结束公司Id")
        Integer endCompanyId;

        @ApiModelProperty(hidden = true)
        Boolean yearNo4Where;

        @ApiModelProperty(hidden = true)
        Integer withoutRecordWhere = 1;

        public void setStartDateTamp(Long startDateTamp) {
            this.startDateTamp = startDateTamp;
            this.startDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startDateTamp), ZoneOffset.ofHours(8)));
            this.startDateExtend = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startDateTamp), ZoneOffset.ofHours(8)).minusDays(1L));
        }

        public void setEndDateTamp(Long endDateTamp) {
                this.endDateTamp = endDateTamp;
                this.endDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endDateTamp), ZoneOffset.ofHours(8)));
                this.endDateExtend = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endDateTamp), ZoneOffset.ofHours(8)).plusDays(1L));
        }
}