package com.xxfc.platform.uccn.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.uccn.dto.ModelDto;
import com.xxfc.platform.uccn.entity.Model;
import com.xxfc.platform.uccn.vo.ModelVo;
import com.xxfc.platform.uccn.mapper.ModelBackgroundMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class ModelBackgroundBiz extends BaseBiz<ModelBackgroundMapper, Model> {
    private final Integer BASE_PARENT_ID = 0;

    private final Integer NOT_DELETE = 0;

    private final Integer level=2;

    @Autowired
    private ApplicationContext context;

    public List<ModelDto> getList() {
        List<Model> ModelList = getProxy().getListByParentId(BASE_PARENT_ID);
        if (CollectionUtils.isEmpty(ModelList)) {
            return new ArrayList<>();
        }
        return getModelDtos(ModelList);
    }

    /**
     * 获取ModelDto集合
     * @param models
     * @return
     */
    private ArrayList<ModelDto> getModelDtos(List<Model> models) {
        ArrayList<ModelDto> modelDtos = new ArrayList<>();
        for (Model el : models) {
            if (el.getLevel()==3) {
                break;
            }
            List<Model> list = getListByParentId(el.getId());
            modelDtos.add(new ModelDto(el, list));
            modelDtos.addAll(getModelDtos(list));
        }
        return modelDtos;
    }

    /**
     * 根据父类id获取所有子类集合
     *
     * @param parentId
     * @return
     */
//    @Cache(key = "ModelList{1}")
    public List<Model> getListByParentId(Integer parentId) {
        Example exa  = new Example(Model.class);
        Example.Criteria criteria = exa.createCriteria();
        criteria.andEqualTo("parentId",parentId).andEqualTo("isDel",NOT_DELETE);
        exa.orderBy("rank").asc();
        return mapper.selectByExample(exa);
    }

    /**
     * 获取代理对象
     *
     * @return
     */
    private ModelBackgroundBiz getProxy() {
        return context.getBean(ModelBackgroundBiz.class);
    }


    /**
     * 修改子模块
     *
     * @param Modelvo
     * @return
     */
//    @CacheClear(key = "ModelList{1.Integer}")
    public String update(ModelVo Modelvo) {
        if (Modelvo==null||Modelvo.getParentId()==null) {
            return "无修改数据";
        }
        Model Model = selectById(Modelvo.getParentId());
        if (Model==null||(!Model.getIsDel().equals(NOT_DELETE))||BASE_PARENT_ID.equals(Model.getParentId())) {
            return "该标签不能修改";
        }

        if (CollectionUtils.isNotEmpty(Modelvo.getList())) {
            for (Model el : Modelvo.getList()) {
                if (el.getId()==null) {
                    el.setIsDel(NOT_DELETE);
                    el.setCreTime(new Date());
                    el.setParentId(Modelvo.getParentId());
                    if (el.getRank() == null) {
                        el.setRank(0);
                    }
                    mapper.insertSelective(el);
                }else {
                    el.setUpdTime(new Date());
                    mapper.updateByPrimaryKeySelective(el);
                }
            }
        }
      return null;
    }
}
